/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.entity.FireJetBlockEntity;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.data.tags.FluidTagGenerator;
import twilightforest.enums.FireJetVariant;
import twilightforest.init.TFBlockEntities;

public class FireJetBlock
extends BaseEntityBlock {
    public static final EnumProperty<FireJetVariant> STATE = EnumProperty.m_61587_((String)"state", FireJetVariant.class);

    public FireJetBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(STATE, (Comparable)((Object)FireJetVariant.IDLE)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{STATE});
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter getter, BlockPos pos, @Nullable Mob entity) {
        return state.m_61143_(STATE) == FireJetVariant.IDLE ? null : BlockPathTypes.DAMAGE_FIRE;
    }

    @Deprecated
    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos lavaPos;
        if (!level.m_5776_() && state.m_61143_(STATE) == FireJetVariant.IDLE && this.isLava((Level)level, lavaPos = this.findLavaAround((Level)level, pos.m_7495_()))) {
            level.m_46597_(lavaPos, Blocks.f_50016_.m_49966_());
            level.m_46597_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)FireJetVariant.POPPING)));
        }
    }

    private BlockPos findLavaAround(Level level, BlockPos pos) {
        if (this.isLava(level, pos)) {
            return pos;
        }
        for (int i = 0; i < 3; ++i) {
            BlockPos randPos = pos.m_7918_(level.m_213780_().m_188503_(3) - 1, 0, level.m_213780_().m_188503_(3) - 1);
            if (!this.isLava(level, randPos)) continue;
            return randPos;
        }
        return pos;
    }

    private boolean isLava(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_204336_(BlockTagGenerator.FIRE_JET_FUEL) || state.m_60734_().m_5888_(state).m_205070_(FluidTagGenerator.FIRE_JET_FUEL);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FireJetBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return FireJetBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TFBlockEntities.FLAME_JET.get()), FireJetBlockEntity::tick);
    }
}

