/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.integration.emi;

import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_6880;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.integration.emi.EMIPlugin;
import org.betterx.bclib.recipes.AnvilRecipe;
import org.jetbrains.annotations.Nullable;

public class EMIAnvilRecipe
implements EmiRecipe {
    private final class_2960 id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    private final EmiRecipeCategory category;

    public EMIAnvilRecipe(AnvilRecipe recipe, class_1792 hammer) {
        this.id = new class_2960("emi", recipe.method_8114().method_12836() + "/" + recipe.method_8114().method_12832() + "/anvil/" + hammer.method_7876());
        this.input = List.of(EmiIngredient.of((class_1856)recipe.getMainIngredient(), (long)recipe.getInputCount()), EmiIngredient.of((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{hammer})));
        this.output = List.of(EmiStack.of((class_1799)recipe.method_8110(class_310.method_1551().field_1687.method_30349())));
        this.category = EMIPlugin.getAnvilCategoryForLevel(recipe.getAnvilLevel());
    }

    static void addAllRecipes(EmiRegistry emiRegistry, class_1863 manager) {
        Iterable<class_6880<class_1792>> hammers = AnvilRecipe.getAllHammers();
        EMIPlugin.addAllRecipes(emiRegistry, manager, BCLib.LOGGER, AnvilRecipe.TYPE, recipe -> StreamSupport.stream(hammers.spliterator(), false).map(class_6880::comp_349).filter(recipe::canUse).toList(), EMIAnvilRecipe::new);
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 104;
    }

    public int getDisplayHeight() {
        return 26;
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        widgetHolder.addTexture(EmiTexture.EMPTY_ARROW, 46, 5);
        widgetHolder.addSlot(this.input.get(0), 0, 4);
        widgetHolder.addSlot(this.input.get(1), 20, 4).catalyst(true);
        widgetHolder.addSlot((EmiIngredient)this.output.get(0), 78, 0).large(true).recipeContext((EmiRecipe)this);
    }

    public List<EmiIngredient> getCatalysts() {
        return List.of(this.input.get(1));
    }

    public boolean supportsRecipeTree() {
        return true;
    }
}

