/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.components.HorizontalStack;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.VerticalStack;
import de.ambertation.wunderlib.ui.layout.values.Size;
import de.ambertation.wunderlib.ui.layout.values.Value;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import org.betterx.bclib.client.gui.screens.BCLibLayoutScreen;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.networking.VersionChecker;

@Environment(value=EnvType.CLIENT)
public class UpdatesScreen
extends BCLibLayoutScreen {
    public static final String DONATION_URL = "https://www.buymeacoffee.com/quiqueck";
    static final class_2960 UPDATE_LOGO_LOCATION = new class_2960("bclib", "icon_updater.png");

    public UpdatesScreen(class_437 parent) {
        super(parent, (class_2561)class_2561.method_43471((String)"bclib.updates.title"), 10, 10, 10);
    }

    public static void showUpdateUI() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> class_310.method_1551().method_1507((class_437)new UpdatesScreen(class_310.method_1551().field_1755)));
        } else {
            class_310.method_1551().method_1507((class_437)new UpdatesScreen(class_310.method_1551().field_1755));
        }
    }

    public class_2960 getUpdaterIcon(String modID) {
        CustomValue.CvObject obj;
        CustomValue element;
        if (modID.equals("bclib")) {
            return UPDATE_LOGO_LOCATION;
        }
        ModContainer nfo = FabricLoader.getInstance().getModContainer(modID).orElse(null);
        if (nfo != null && (element = nfo.getMetadata().getCustomValue("bclib")) != null && (obj = element.getAsObject()) != null) {
            CustomValue icon = obj.get("updater_icon");
            return new class_2960(modID, icon.getAsString());
        }
        return null;
    }

    protected LayoutComponent<?, ?> initContent() {
        VerticalStack rows = (VerticalStack)new VerticalStack(UpdatesScreen.relative((double)1.0), UpdatesScreen.fit()).centerHorizontal();
        rows.addMultilineText(UpdatesScreen.fill(), UpdatesScreen.fit(), (class_2561)class_2561.method_43471((String)"bclib.updates.description")).centerHorizontal();
        rows.addSpacer(8);
        VersionChecker.forEachUpdate((mod, cur, updated) -> {
            ModContainer nfo = FabricLoader.getInstance().getModContainer(mod).orElse(null);
            class_2960 icon = this.getUpdaterIcon(mod);
            HorizontalStack row = (HorizontalStack)rows.addRow(UpdatesScreen.fixed((int)320), UpdatesScreen.fit()).centerHorizontal();
            if (icon != null) {
                row.addImage(Value.fit(), Value.fit(), icon, Size.of((int)32));
                row.addSpacer(4);
            } else {
                row.addSpacer(36);
            }
            if (nfo != null) {
                row.addText(UpdatesScreen.fit(), UpdatesScreen.fit(), (class_2561)class_2561.method_43470((String)nfo.getMetadata().getName())).setColor(ColorHelper.WHITE);
            } else {
                row.addText(UpdatesScreen.fit(), UpdatesScreen.fit(), (class_2561)class_2561.method_43470((String)mod)).setColor(ColorHelper.WHITE);
            }
            row.addSpacer(4);
            row.addText(UpdatesScreen.fit(), UpdatesScreen.fit(), (class_2561)class_2561.method_43470((String)cur));
            row.addText(UpdatesScreen.fit(), UpdatesScreen.fit(), (class_2561)class_2561.method_43470((String)" -> "));
            row.addText(UpdatesScreen.fit(), UpdatesScreen.fit(), (class_2561)class_2561.method_43470((String)updated)).setColor(ColorHelper.GREEN);
            row.addFiller();
            boolean createdDownloadLink = false;
            if (nfo != null && nfo.getMetadata().getCustomValue("bclib") != null && nfo.getMetadata().getCustomValue("bclib").getAsObject().get("downloads") != null) {
                CustomValue.CvObject downloadLinks = nfo.getMetadata().getCustomValue("bclib").getAsObject().get("downloads").getAsObject();
                String link = null;
                class_5250 name = null;
                if (Configs.CLIENT_CONFIG.preferModrinthForUpdates() && downloadLinks.get("modrinth") != null) {
                    link = downloadLinks.get("modrinth").getAsString();
                    name = class_2561.method_43471((String)"bclib.updates.modrinth_link");
                } else if (downloadLinks.get("curseforge") != null) {
                    link = downloadLinks.get("curseforge").getAsString();
                    name = class_2561.method_43471((String)"bclib.updates.curseforge_link");
                }
                if (link != null) {
                    createdDownloadLink = true;
                    String finalLink = link;
                    row.addButton(UpdatesScreen.fit(), UpdatesScreen.fit(), (class_2561)name).onPress(bt -> this.openLink(finalLink)).centerVertical();
                }
            }
            if (!createdDownloadLink && nfo != null && nfo.getMetadata().getContact().get("homepage").isPresent()) {
                row.addButton(UpdatesScreen.fit(), UpdatesScreen.fit(), (class_2561)class_2561.method_43471((String)"bclib.updates.download_link")).onPress(bt -> this.openLink((String)nfo.getMetadata().getContact().get("homepage").get())).centerVertical();
            }
        });
        VerticalStack layout = (VerticalStack)new VerticalStack(UpdatesScreen.relative((double)1.0), UpdatesScreen.fill()).centerHorizontal();
        layout.addScrollable((LayoutComponent)rows);
        layout.addSpacer(8);
        HorizontalStack footer = layout.addRow(UpdatesScreen.fill(), UpdatesScreen.fit());
        if (Configs.CLIENT_CONFIG.isDonor()) {
            footer.addButton(UpdatesScreen.fit(), UpdatesScreen.fit(), (class_2561)class_2561.method_43471((String)"bclib.updates.donate").method_10862(class_2583.field_24360.method_36139(ColorHelper.YELLOW))).onPress(bt -> this.openLink(DONATION_URL));
            footer.addSpacer(2);
            footer.addMultilineText(UpdatesScreen.fit(), UpdatesScreen.fit(), (class_2561)class_2561.method_43471((String)"bclib.updates.donate_pre")).alignBottom();
        }
        footer.addFiller();
        footer.addCheckbox(UpdatesScreen.fit(), UpdatesScreen.fit(), (class_2561)class_2561.method_43471((String)"Disable Check"), !Configs.CLIENT_CONFIG.checkVersions()).onChange((cb, state) -> {
            Configs.CLIENT_CONFIG.setCheckVersions(!state);
            Configs.CLIENT_CONFIG.saveChanges();
        });
        footer.addSpacer(4);
        footer.addButton(UpdatesScreen.fit(), UpdatesScreen.fit(), class_5244.field_24334).onPress(bt -> this.method_25419());
        return layout;
    }

    protected void renderBackground(class_332 guiGraphics, int i, int j, float f) {
        guiGraphics.method_25294(0, 0, this.field_22789, this.field_22790, -1120652220);
    }
}

