/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_793;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.TagProvider;
import org.betterx.bclib.registry.BaseBlockEntities;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;
import org.betterx.worlds.together.tag.v3.CommonItemTags;
import org.jetbrains.annotations.Nullable;

public abstract class BaseChestBlock
extends class_2281
implements BlockModelProvider,
TagProvider,
DropSelfLootProvider<BaseChestBlock> {
    private final class_2248 parent;

    protected BaseChestBlock(class_2248 source) {
        super(class_4970.class_2251.method_9630((class_4970)source).method_22488(), () -> BaseBlockEntities.CHEST);
        this.parent = source;
    }

    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return BaseBlockEntities.CHEST.method_11032(blockPos, blockState);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_793 getItemModel(class_2960 blockId) {
        Optional<String> pattern = PatternsHelper.createJson(BasePatterns.ITEM_CHEST, blockId);
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public class_793 getBlockModel(class_2960 resourceLocation, class_2680 blockState) {
        class_2960 parentId = class_7923.field_41175.method_10221((Object)this.parent);
        return ModelsHelper.createBlockEmpty(parentId);
    }

    @Override
    public void addTags(List<class_6862<class_2248>> blockTags, List<class_6862<class_1792>> itemTags) {
        blockTags.add(CommonBlockTags.CHEST);
        itemTags.add(CommonItemTags.CHEST);
    }

    public static BaseChestBlock from(class_2248 source) {
        return new Wood(source);
    }

    public static class Wood
    extends BaseChestBlock
    implements BehaviourWood {
        public Wood(class_2248 source) {
            super(source);
        }

        @Override
        public void addTags(List<class_6862<class_2248>> blockTags, List<class_6862<class_1792>> itemTags) {
            super.addTags(blockTags, itemTags);
            blockTags.add(CommonBlockTags.WOODEN_CHEST);
            itemTags.add(CommonItemTags.WOODEN_CHEST);
        }
    }
}

