/*
 * Decompiled with CFR 0.152.
 */
package net.projectile_damage.mixin;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.projectile_damage.api.EntityAttributes_ProjectileDamage;
import net.projectile_damage.api.IProjectileWeapon;
import net.projectile_damage.api.RangedWeaponKind;
import net.projectile_damage.internal.Constants;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={ProjectileWeaponItem.class})
abstract class RangedWeaponItemMixin
extends Item
implements IProjectileWeapon {
    private Multimap<Attribute, AttributeModifier> attributeModifiers = null;
    private List<EquipmentSlot> allowedSlots = List.of(EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND);
    private Double customLaunchVelocity = null;
    private RangedWeaponKind rangedWeaponKind = RangedWeaponKind.from(this);
    private double projectileDamage = 0.0;

    RangedWeaponItemMixin(Item.Properties settings) {
        super(settings);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return this.allowedSlots.contains(slot) && this.attributeModifiers != null ? this.attributeModifiers : super.m_7167_(slot);
    }

    @Override
    public void setRangedWeaponKind(RangedWeaponKind kind) {
        this.rangedWeaponKind = kind;
        if (this.projectileDamage == 0.0) {
            this.setProjectileDamage(kind.damage());
        }
    }

    @Override
    public RangedWeaponKind getRangeWeaponKind() {
        return this.rangedWeaponKind;
    }

    @Override
    public void setProjectileDamage(double value, boolean mainHand, boolean offHand) {
        this.allowedSlots = new ArrayList<EquipmentSlot>();
        if (mainHand) {
            this.allowedSlots.add(EquipmentSlot.MAINHAND);
        }
        if (offHand) {
            this.allowedSlots.add(EquipmentSlot.OFFHAND);
        }
        this.projectileDamage = value;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)EntityAttributes_ProjectileDamage.GENERIC_PROJECTILE_DAMAGE, (Object)new AttributeModifier(Constants.GENERIC_PROJECTILE_MODIFIER_ID, "Projectile damage", value, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    @Override
    public double getProjectileDamage() {
        return this.projectileDamage;
    }

    @Override
    public void setCustomLaunchVelocity(Double value) {
        this.customLaunchVelocity = value;
    }

    @Override
    public Double getCustomLaunchVelocity() {
        return this.customLaunchVelocity;
    }
}

