/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.world.feature;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.soulsweaponry.world.feature.ConfiguredFeatures;
import net.soulsweaponry.world.feature.OrePlacement;

public class PlacedFeatures {
    public static final int VERGLAS_ORE_COUNT_PER_CHUNK = 50;
    public static final int VERGLAS_ORE_MIN_HEIGHT = -80;
    public static int VERGLAS_ORE_MAX_HEIGHT = 300;
    public static final int MOONSTONE_ORE_COUNT_PER_CHUNK = 4;
    public static final int MOONSTONE_ORE_MIN_HEIGHT = -80;
    public static final int MOONSTONE_ORE_MAX_HEIGHT = 16;
    public static final ResourceKey<PlacedFeature> MOONSTONE_ORE_PLACED_KEY = PlacedFeatures.registerKey("moonstone_ore_placed");
    public static final ResourceKey<PlacedFeature> VERGLAS_ORE_PLACED_KEY = PlacedFeatures.registerKey("verglas_ore_placed");

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        HolderGetter featureLookup = context.m_255420_(Registries.f_256911_);
        PlacedFeatures.register(context, MOONSTONE_ORE_PLACED_KEY, featureLookup.m_255043_(ConfiguredFeatures.MOONSTONE_ORE_KEY), OrePlacement.modifiersWithCount(4, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-80), (VerticalAnchor)VerticalAnchor.m_158922_((int)16))));
        PlacedFeatures.register(context, VERGLAS_ORE_PLACED_KEY, featureLookup.m_255043_(ConfiguredFeatures.VERGLAS_ORE_KEY), OrePlacement.modifiersWithCount(50, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-80), (VerticalAnchor)VerticalAnchor.m_158922_((int)VERGLAS_ORE_MAX_HEIGHT))));
    }

    public static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("soulsweapons", name));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> config, List<PlacementModifier> modifiers) {
        context.m_255272_(key, (Object)new PlacedFeature(config, List.copyOf(modifiers)));
    }
}

