/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.util;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.ForgeRegistries;
import net.soulsweaponry.util.LuckChosenObject;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class WeaponUtil {
    public static final Enchantment[] DAMAGE_ENCHANTS = new Enchantment[]{Enchantments.f_44977_, Enchantments.f_44978_, Enchantments.f_44979_};

    public static int getEnchantDamageBonus(ItemStack stack) {
        for (Enchantment ench : DAMAGE_ENCHANTS) {
            if (EnchantmentHelper.m_44843_((Enchantment)ench, (ItemStack)stack) <= 0) continue;
            return EnchantmentHelper.m_44843_((Enchantment)ench, (ItemStack)stack);
        }
        return 0;
    }

    public static boolean isModLoaded(String modId) {
        return FMLLoader.getLoadingModList().getModFileById(modId) != null;
    }

    public static boolean isFightModLoaded() {
        return WeaponUtil.isModLoaded("bettercombat") || WeaponUtil.isModLoaded("epicfight");
    }

    public static List<Integer> arrayToList(int[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int t : array) {
            list.add(t);
        }
        return list;
    }

    public static int getChargeTime(ItemStack stack, int remainingUseTicks) {
        int i = WeaponUtil.isModLoaded("epicfight") ? Integer.MAX_VALUE - remainingUseTicks : stack.m_41720_().m_8105_(stack) - remainingUseTicks;
        return i;
    }

    public static void doConsumerOnCircle(Level world, float yaw, Vec3 startPos, double maxYOffset, int ripples, Vec2 radiusAndMod, TriConsumer<Vec3, Integer, Float> consumer) {
        double minY = startPos.m_7098_() - maxYOffset;
        double maxY = startPos.m_7098_() + maxYOffset;
        float yawRad = (float)Math.toRadians(yaw);
        for (int wave = 0; wave < ripples; ++wave) {
            double radius = radiusAndMod.f_82470_ + (float)wave * radiusAndMod.f_82471_;
            int step = Mth.m_14143_((float)(80.0f / ((float)wave + 1.0f)));
            for (int angleDeg = 0; angleDeg < 360; angleDeg += step) {
                float totalRad = yawRad + (float)angleDeg * (float)Math.PI / 180.0f;
                double x = startPos.m_7096_() + radius * Math.cos(totalRad);
                double z = startPos.m_7094_() + radius * Math.sin(totalRad);
                int warmup = 3 * (wave + 1);
                float spawnYaw = yaw + (float)angleDeg;
                WeaponUtil.doConsumerOnPoint(world, x, z, minY, maxY, warmup, spawnYaw, consumer);
            }
        }
    }

    public static void doConsumerOnLine(Level world, float yaw, Vec3 startPos, double maxYOffset, int amount, float spacingModifier, TriConsumer<Vec3, Integer, Float> consumer) {
        double minY = startPos.m_7098_() - maxYOffset;
        double maxY = startPos.m_7098_() + maxYOffset;
        float f = (float)Math.toRadians(yaw);
        for (int i = 0; i < amount; ++i) {
            double h = (double)spacingModifier * (double)(i + 1);
            WeaponUtil.doConsumerOnPoint(world, startPos.m_7096_() + (double)Mth.m_14089_((float)f) * h, startPos.m_7094_() + (double)Mth.m_14031_((float)f) * h, minY, maxY, -6 + i * 2, yaw, consumer);
        }
    }

    public static void doConsumerOnPoint(Level world, double x, double z, double minY, double maxY, int warmup, float yaw, TriConsumer<Vec3, Integer, Float> consumer) {
        BlockPos blockPos = BlockPos.m_274561_((double)x, (double)maxY, (double)z);
        boolean valid = false;
        double shapeOffset = 0.0;
        do {
            BlockState blockState2;
            VoxelShape voxelShape;
            BlockPos blockPos2;
            BlockState blockState;
            if (!(blockState = world.m_8055_(blockPos2 = blockPos.m_7495_())).m_60783_((BlockGetter)world, blockPos2, Direction.UP)) continue;
            if (!world.m_46859_(blockPos) && !(voxelShape = (blockState2 = world.m_8055_(blockPos)).m_60812_((BlockGetter)world, blockPos)).m_83281_()) {
                shapeOffset = voxelShape.m_83297_(Direction.Axis.Y);
            }
            valid = true;
            break;
        } while ((blockPos = blockPos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (valid) {
            consumer.accept((Object)new Vec3(x, (double)blockPos.m_123342_() + shapeOffset, z), (Object)warmup, (Object)Float.valueOf(yaw));
        }
    }

    public static int getLuckFactor(LivingEntity entity) {
        return Mth.m_14107_((double)(entity.m_21133_(Attributes.f_22286_) * 2.0 + 2.0));
    }

    @Nullable
    public static <T> T getRandomlyChosenObject(LivingEntity user, List<LuckChosenObject<T>> list, boolean flipLuckTypes) {
        ArrayList<LuckChosenObject<T>> projectileList = new ArrayList<LuckChosenObject<T>>();
        int modifier = flipLuckTypes ? -1 : 1;
        for (LuckChosenObject<T> luckChosenObject : list) {
            switch (luckChosenObject.getLuckType().ordinal()) {
                case 2: {
                    luckChosenObject.setLuckFactor(luckChosenObject.getLuckFactor() + modifier * -WeaponUtil.getLuckFactor(user));
                    break;
                }
                case 0: {
                    luckChosenObject.setLuckFactor(luckChosenObject.getLuckFactor() + modifier * WeaponUtil.getLuckFactor(user));
                }
            }
            if (luckChosenObject.getLuckFactor() <= 0) continue;
            projectileList.add(luckChosenObject);
        }
        int totalChance = 0;
        for (LuckChosenObject luckChosenObject : projectileList) {
            totalChance += luckChosenObject.getLuckFactor();
        }
        int n = user.m_217043_().m_188503_(totalChance);
        boolean bl = false;
        for (LuckChosenObject luckChosenObject : projectileList) {
            if (n >= (var7_12 += luckChosenObject.getLuckFactor())) continue;
            return luckChosenObject.getObject();
        }
        return null;
    }

    public static void launchTarget(LivingEntity target, float launchPower, boolean reverse) {
        float f = target.m_146908_();
        float g = target.m_146909_();
        float rad = (float)Math.PI / 180;
        float h = -Mth.m_14031_((float)(f * rad)) * Mth.m_14089_((float)(g * rad));
        float k = -Mth.m_14031_((float)(g * rad));
        float l = Mth.m_14089_((float)(f * rad)) * Mth.m_14089_((float)(g * rad));
        float m = Mth.m_14116_((float)(h * h + k * k + l * l));
        float n = 3.0f * (launchPower / 4.0f);
        h *= n / m;
        k *= n / m;
        l *= n / m;
        if (reverse) {
            h = -h;
            k = -k;
            l = -l;
        }
        target.m_5997_((double)h, (double)k, (double)l);
    }

    @Nullable
    public static AttributeModifier makeAttribute(Attribute attr, EquipmentSlot slot, float amount) {
        if (amount == 0.0f) {
            return null;
        }
        String seed = String.format("soulsweapons:%s:%s", attr.m_22087_(), slot.m_20751_().toUpperCase());
        UUID uuid = UUID.nameUUIDFromBytes(seed.getBytes(StandardCharsets.UTF_8));
        return new AttributeModifier(uuid, attr.m_22087_() + " " + slot.m_20751_(), (double)amount, AttributeModifier.Operation.ADDITION);
    }

    @Nullable
    public static AttributeModifier makeAttribute(Attribute attr, EquipmentSlot slot, float[] perSlotValues) {
        int idx = switch (slot) {
            case EquipmentSlot.HEAD -> 3;
            case EquipmentSlot.CHEST -> 2;
            case EquipmentSlot.LEGS -> 1;
            case EquipmentSlot.FEET -> 0;
            default -> throw new IllegalArgumentException("Unexpected slot " + String.valueOf(slot));
        };
        double amount = perSlotValues[idx];
        return WeaponUtil.makeAttribute(attr, slot, (float)amount);
    }

    public static List<EntityType<?>> getEntityListOffArray(String[] array) {
        Set<String> stringSet = Set.of(array);
        return stringSet.stream().map(str -> {
            ResourceLocation entityId = new ResourceLocation((String)(str.contains(":") ? str : "minecraft:" + str));
            return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
        }).collect(Collectors.toList());
    }

    public static enum LuckType {
        GOOD,
        NEUTRAL,
        BAD;

    }
}

