/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.util;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class NbtHelper {
    public static CompoundTag serializeUUIDArray(UUID[] uuids) {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < uuids.length; ++i) {
            tag.m_128362_("UUID" + i, uuids[i]);
        }
        return tag;
    }

    public static UUID[] deserializeUUIDArray(CompoundTag tag) {
        UUID[] uuids = new UUID[tag.m_128440_()];
        for (int i = 0; i < tag.m_128440_(); ++i) {
            uuids[i] = tag.m_128342_("UUID" + i);
        }
        return uuids;
    }

    public static void saveUUIDArr(CompoundTag tag, UUID[] uuids, String arrayId) {
        tag.m_128365_(arrayId, (Tag)NbtHelper.serializeUUIDArray(uuids));
    }

    public static UUID[] getUUIDArr(CompoundTag tag, String arrayId) {
        return NbtHelper.deserializeUUIDArray(tag.m_128469_(arrayId));
    }

    public static void saveUUIDArrToStack(ItemStack stack, UUID[] uuids, String arrayId) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_(arrayId, (Tag)NbtHelper.serializeUUIDArray(uuids));
        stack.m_41751_(tag);
    }

    public static UUID[] getUUIDArrFromStack(ItemStack stack, String arrayId) {
        CompoundTag tag = stack.m_41784_();
        return NbtHelper.deserializeUUIDArray(tag.m_128469_(arrayId));
    }

    public static void addUUIDToArr(CompoundTag tag, UUID uuid, String arrayId) {
        UUID[] existingUUIDs = NbtHelper.getUUIDArr(tag, arrayId);
        UUID[] newUUIDs = new UUID[existingUUIDs.length + 1];
        System.arraycopy(existingUUIDs, 0, newUUIDs, 0, existingUUIDs.length);
        newUUIDs[existingUUIDs.length] = uuid;
        NbtHelper.saveUUIDArr(tag, newUUIDs, arrayId);
    }

    public static UUID[] addUUIDToArr(UUID[] existingUUIDs, UUID uuid) {
        UUID[] newUUIDs = new UUID[existingUUIDs.length + 1];
        System.arraycopy(existingUUIDs, 0, newUUIDs, 0, existingUUIDs.length);
        newUUIDs[existingUUIDs.length] = uuid;
        return newUUIDs;
    }

    public static void removeUUIDFromArr(CompoundTag tag, UUID uuidToRemove, String arrayId) {
        UUID[] existingUUIDs = NbtHelper.getUUIDArr(tag, arrayId);
        int newSize = existingUUIDs.length - 1;
        UUID[] newUUIDs = new UUID[newSize];
        int newIndex = 0;
        for (UUID uuid : existingUUIDs) {
            if (uuid.equals(uuidToRemove)) continue;
            newUUIDs[newIndex] = uuid;
            ++newIndex;
        }
        NbtHelper.saveUUIDArr(tag, newUUIDs, arrayId);
    }
}

