/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.registry;

import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.soulsweaponry.fluid.PurifiedBlood;
import net.soulsweaponry.fluid.PurifiedBloodCauldronBlock;
import net.soulsweaponry.registry.BlockRegistry;
import net.soulsweaponry.registry.ItemRegistry;

public class FluidRegistry {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"soulsweapons");
    public static final RegistryObject<FlowingFluid> STILL_PURIFIED_BLOOD = FluidRegistry.registerFluid("purified_blood", PurifiedBlood.Still::new);
    public static final RegistryObject<FlowingFluid> FLOWING_PURIFIED_BLOOD = FluidRegistry.registerFluid("flowing_purified_blood", PurifiedBlood.Flowing::new);
    public static final Predicate<Biome.Precipitation> NONE_PREDICATE = precipitation -> precipitation == Biome.Precipitation.NONE;
    public static final Map<Item, CauldronInteraction> BLOOD_CAULDRON_BEHAVIOR = CauldronInteraction.m_175617_();

    public static void registerCauldronBehavior() {
        CauldronInteraction.f_175606_.put((Item)ItemRegistry.PURIFIED_BLOOD_BUCKET.get(), (state, world, pos, player, hand, stack) -> CauldronInteraction.m_175618_((Level)world, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (BlockState)((BlockState)((PurifiedBloodCauldronBlock)((Object)((Object)BlockRegistry.PURIFIED_BLOOD_CAULDRON.get()))).m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3))), (SoundEvent)SoundEvents.f_11778_));
        BLOOD_CAULDRON_BEHAVIOR.put(Items.f_42446_, (state, world, pos, player, hand, stack) -> CauldronInteraction.m_175635_((BlockState)state, (Level)world, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (ItemStack)new ItemStack((ItemLike)ItemRegistry.PURIFIED_BLOOD_BUCKET.get()), state1 -> (Integer)state1.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, (SoundEvent)SoundEvents.f_11781_));
        BLOOD_CAULDRON_BEHAVIOR.put((Item)ItemRegistry.GLASS_VIAL.get(), (state, world, pos, player, hand, stack) -> {
            if (!world.f_46443_) {
                Item item = stack.m_41720_();
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)((Item)ItemRegistry.BLOOD_VIAL.get()).m_7968_()));
                player.m_36220_(Stats.f_12944_);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                LayeredCauldronBlock.m_153559_((BlockState)state, (Level)world, (BlockPos)pos);
                world.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_142346_(null, GameEvent.f_157816_, pos);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        });
        BLOOD_CAULDRON_BEHAVIOR.put(Items.f_42590_, (state, world, pos, player, hand, stack) -> CauldronInteraction.m_175635_((BlockState)state, (Level)world, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43623_), state1 -> (Integer)state1.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, (SoundEvent)SoundEvents.f_11781_));
    }

    private static <I extends Fluid> RegistryObject<I> registerFluid(String name, Supplier<I> fluid) {
        return FLUIDS.register(name, fluid);
    }

    public static void register(IEventBus eventBus) {
        FLUIDS.register(eventBus);
    }
}

