/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.registry;

import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.enchantments.BlightCarrierEnchantment;
import net.soulsweaponry.enchantments.ChainLightningEnchantment;
import net.soulsweaponry.enchantments.EtherealEnchantment;
import net.soulsweaponry.enchantments.ExplosiveEnchantment;
import net.soulsweaponry.enchantments.FastHandsEnchantment;
import net.soulsweaponry.enchantments.FrostsilverEnchantment;
import net.soulsweaponry.enchantments.MisfireCurseEnchantment;
import net.soulsweaponry.enchantments.PhantomTraceEnchantment;
import net.soulsweaponry.enchantments.RicochetEnchantment;
import net.soulsweaponry.enchantments.StaggerEnchantment;
import net.soulsweaponry.enchantments.TetherEnchantment;
import net.soulsweaponry.enchantments.VisceralEnchantment;
import net.soulsweaponry.items.gun.GunItem;

public class EnchantRegistry {
    public static final EnchantmentCategory GUN = EnchantmentCategory.create((String)"gun", item -> item instanceof GunItem);
    public static final DeferredRegister<Enchantment> ENCHANTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"soulsweapons");
    public static final Enchantment FAST_HANDS = new FastHandsEnchantment(Enchantment.Rarity.RARE, EquipmentSlot.MAINHAND);
    public static final Enchantment VISCERAL = new VisceralEnchantment(Enchantment.Rarity.UNCOMMON, EquipmentSlot.MAINHAND);
    public static final Enchantment STAGGER = new StaggerEnchantment(Enchantment.Rarity.UNCOMMON, EquipmentSlot.MAINHAND);
    public static final Enchantment ETHEREAL = new EtherealEnchantment(Enchantment.Rarity.VERY_RARE, EquipmentSlot.MAINHAND);
    public static final Enchantment EXPLOSIVE_ROUNDS = new ExplosiveEnchantment(Enchantment.Rarity.VERY_RARE, EquipmentSlot.MAINHAND);
    public static final Enchantment CHAIN_LIGHTNING = new ChainLightningEnchantment(Enchantment.Rarity.RARE, EquipmentSlot.MAINHAND);
    public static final Enchantment MISFIRE_CURSE = new MisfireCurseEnchantment(Enchantment.Rarity.VERY_RARE, EquipmentSlot.MAINHAND);
    public static final Enchantment BLIGHT_CARRIER = new BlightCarrierEnchantment(Enchantment.Rarity.RARE, EquipmentSlot.MAINHAND);
    public static final Enchantment FROSTSILVER = new FrostsilverEnchantment(Enchantment.Rarity.UNCOMMON, EquipmentSlot.MAINHAND);
    public static final Enchantment PHANTOM_TRACE = new PhantomTraceEnchantment(Enchantment.Rarity.RARE, EquipmentSlot.MAINHAND);
    public static final Enchantment TETHER = new TetherEnchantment(Enchantment.Rarity.UNCOMMON, EquipmentSlot.MAINHAND);
    public static final Enchantment RICOCHET = new RicochetEnchantment(Enchantment.Rarity.RARE, EquipmentSlot.MAINHAND);

    public static void register(IEventBus bus) {
        ENCHANTS.register(bus);
    }

    static {
        if (!ConfigConstructor.disable_all_enchantments) {
            if (!ConfigConstructor.disable_enchantment_fast_hands) {
                ENCHANTS.register("fast_hands", () -> FAST_HANDS);
            }
            if (!ConfigConstructor.disable_enchantment_posture_breaker) {
                ENCHANTS.register("visceral", () -> VISCERAL);
            }
            if (!ConfigConstructor.disable_enchantment_stagger) {
                ENCHANTS.register("stagger", () -> STAGGER);
            }
            if (!ConfigConstructor.disable_enchantment_ethereal_ammunition) {
                ENCHANTS.register("ethereal", () -> ETHEREAL);
            }
            if (!ConfigConstructor.disable_enchantment_explosive_rounds) {
                ENCHANTS.register("explosive_rounds", () -> EXPLOSIVE_ROUNDS);
            }
            if (!ConfigConstructor.disable_enchantment_chain_lightning) {
                ENCHANTS.register("chain_lightning", () -> CHAIN_LIGHTNING);
            }
            if (!ConfigConstructor.disable_enchantment_misfire_curse) {
                ENCHANTS.register("misfire_curse", () -> MISFIRE_CURSE);
            }
            if (!ConfigConstructor.disable_enchantment_blight_carrier) {
                ENCHANTS.register("blight_carrier", () -> BLIGHT_CARRIER);
            }
            if (!ConfigConstructor.disable_enchantment_frostsilver) {
                ENCHANTS.register("frostsilver", () -> FROSTSILVER);
            }
            if (!ConfigConstructor.disable_enchantment_phantom_trace) {
                ENCHANTS.register("phantom_trace", () -> PHANTOM_TRACE);
            }
            if (!ConfigConstructor.disable_enchantment_tether) {
                ENCHANTS.register("tether", () -> TETHER);
            }
            if (!ConfigConstructor.disable_enchantment_ricochet) {
                ENCHANTS.register("ricochet", () -> RICOCHET);
            }
        }
    }
}

