/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.registry;

import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.soulsweaponry.SoulsWeaponry;
import net.soulsweaponry.blocks.AltarBlock;
import net.soulsweaponry.blocks.BlackstonePedestal;
import net.soulsweaponry.blocks.ChungusMonolith;
import net.soulsweaponry.blocks.CrimsonObsidian;
import net.soulsweaponry.blocks.SoulLampBlock;
import net.soulsweaponry.blocks.WitheredBlock;
import net.soulsweaponry.blocks.WitheredFlower;
import net.soulsweaponry.blocks.WitheredGrass;
import net.soulsweaponry.blocks.WitheredTallFlower;
import net.soulsweaponry.blocks.WitheredTallGrass;
import net.soulsweaponry.fluid.PurifiedBloodBlock;
import net.soulsweaponry.fluid.PurifiedBloodCauldronBlock;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.FluidRegistry;
import net.soulsweaponry.registry.ItemRegistry;

public class BlockRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"soulsweapons");
    public static final RegistryObject<Block> CRIMSON_OBSIDIAN = BlockRegistry.registerBlockAndItem("crimson_obsidian", () -> new CrimsonObsidian(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50080_).m_60913_(50.0f, 1200.0f).m_60918_(SoundType.f_56742_).m_60953_(state -> 10).m_60999_().m_60955_()));
    public static final RegistryObject<Block> INFUSED_BLACKSTONE = BlockRegistry.registerBlockAndItem("infused_blackstone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50730_).m_60913_(1.8f, 7.0f).m_60918_(SoundType.f_56742_).m_60999_()));
    public static final RegistryObject<Block> CRACKED_INFUSED_BLACKSTONE = BlockRegistry.registerBlockAndItem("cracked_infused_blackstone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50730_).m_60913_(1.8f, 7.0f).m_60918_(SoundType.f_56742_).m_60999_()));
    public static final RegistryObject<Block> MOONSTONE_ORE = BlockRegistry.registerBlockAndItem("moonstone_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50089_).m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_56742_).m_60953_(state -> 9).m_60999_(), (IntProvider)UniformInt.m_146622_((int)4, (int)8)));
    public static final RegistryObject<Block> MOONSTONE_ORE_DEEPSLATE = BlockRegistry.registerBlockAndItem("moonstone_ore_deepslate", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152474_).m_60913_(4.5f, 3.0f).m_60918_(SoundType.f_154677_).m_60953_(state -> 9).m_60999_(), (IntProvider)UniformInt.m_146622_((int)4, (int)8)));
    public static final RegistryObject<Block> MOONSTONE_BLOCK = BlockRegistry.registerBlockAndItem("moonstone_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_154654_).m_60999_()));
    public static final RegistryObject<AltarBlock> ALTAR_BLOCK = BlockRegistry.registerBlockAndItem("altar_block", () -> new AltarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50080_).m_60913_(30.0f, 800.0f).m_60918_(SoundType.f_56742_).m_60955_().m_60999_()));
    public static final RegistryObject<WitheredBlock> WITHERED_DIRT = BlockRegistry.registerBlockAndItem("withered_dirt", () -> new WitheredBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49994_).m_60978_(0.3f).m_60918_(SoundType.f_56739_), Blocks.f_50493_));
    public static final RegistryObject<WitheredBlock> WITHERED_GRASS_BLOCK = BlockRegistry.registerBlockAndItem("withered_grass_block", () -> new WitheredBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50440_).m_60978_(0.5f).m_60918_(SoundType.f_56739_), Blocks.f_50440_));
    public static final RegistryObject<WitheredGrass> WITHERED_GRASS = BlockRegistry.registerBlockAndItem("withered_grass", () -> new WitheredGrass(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50034_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_), Blocks.f_50034_));
    public static final RegistryObject<WitheredGrass> WITHERED_FERN = BlockRegistry.registerBlockAndItem("withered_fern", () -> new WitheredGrass(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50034_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_), Blocks.f_50035_));
    public static final RegistryObject<WitheredGrass> WITHERED_BERRY_BUSH = BlockRegistry.registerBlockAndItem("withered_berry_bush", () -> new WitheredGrass(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50034_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_), Blocks.f_50685_));
    public static final RegistryObject<WitheredFlower> HYDRANGEA = BlockRegistry.registerBlockAndItem("hydrangea", () -> new WitheredFlower((Supplier<MobEffect>)EffectRegistry.DECAY, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50112_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_)));
    public static final RegistryObject<WitheredTallGrass> WITHERED_TALL_GRASS = BlockRegistry.registerBlockAndItem("withered_tall_grass", () -> new WitheredTallGrass(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50359_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_), Blocks.f_50359_));
    public static final RegistryObject<WitheredTallGrass> WITHERED_LARGE_FERN = BlockRegistry.registerBlockAndItem("withered_large_fern", () -> new WitheredTallGrass(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50359_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_), Blocks.f_50360_));
    public static final RegistryObject<WitheredTallFlower> OLEANDER = BlockRegistry.registerBlockAndItem("oleander", () -> new WitheredTallFlower((Supplier<MobEffect>)EffectRegistry.DECAY, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50357_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_), Blocks.f_50360_));
    public static final RegistryObject<BlackstonePedestal> BLACKSTONE_PEDESTAL = BlockRegistry.registerBlockAndItem("blackstone_pedestal", () -> new BlackstonePedestal(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50080_).m_60913_(20.0f, 400.0f).m_60918_(SoundType.f_56742_).m_60999_()));
    public static final RegistryObject<Block> VERGLAS_ORE = BlockRegistry.registerBlockAndItem("verglas_ore", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50264_).m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_56742_).m_60999_(), (IntProvider)UniformInt.m_146622_((int)4, (int)8)));
    public static final RegistryObject<Block> VERGLAS_ORE_DEEPSLATE = BlockRegistry.registerBlockAndItem("verglas_ore_deepslate", () -> new DropExperienceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152479_).m_60913_(4.5f, 3.0f).m_60918_(SoundType.f_154677_).m_60999_(), (IntProvider)UniformInt.m_146622_((int)4, (int)8)));
    public static final RegistryObject<Block> VERGLAS_BLOCK = BlockRegistry.registerBlockAndItem("verglas_block", () -> new HalfTransparentBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_).m_284180_(MapColor.f_283772_).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_154654_).m_60955_().m_60999_()));
    public static final RegistryObject<Block> SOULFIRE_STAIN = BlockRegistry.registerBlockAndItem("soulfire_stain", () -> new MagmaBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50450_).m_284180_(MapColor.f_283772_).m_60999_().m_60953_(state -> 3).m_60977_().m_60978_(0.5f).m_60922_((state, world, pos, entityType) -> entityType.m_20672_()).m_60982_((state, world, pos) -> true).m_60991_((state, world, pos) -> true)));
    public static final RegistryObject<Block> SOUL_LAMP = BlockRegistry.registerBlockAndItem("soul_lamp", () -> new SoulLampBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50261_).m_60953_(BlockRegistry.createLightLevelFromLitBlockState(15)).m_60978_(0.3f).m_60918_(SoundType.f_56744_).m_60922_((state, world, pos, type) -> true)));
    public static final RegistryObject<Block> CHUNGUS_MONOLITH = BlockRegistry.registerBlockAndItem("chungus_monolith", () -> new ChungusMonolith(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152559_).m_60913_(3.0f, 3.0f).m_60918_(SoundType.f_56742_).m_60955_().m_60999_()));
    public static final RegistryObject<Block> CHUNGUS_EMERALD_BLOCK = BlockRegistry.registerBlockAndItem("chungus_emerald_block", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283812_).m_280658_(NoteBlockInstrument.BIT).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Block> PURIFIED_BLOOD_BLOCK = BlockRegistry.registerBlockAlone("purified_blood_block", () -> new PurifiedBloodBlock((Supplier<FlowingFluid>)FluidRegistry.STILL_PURIFIED_BLOOD, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_)));
    public static RegistryObject<PurifiedBloodCauldronBlock> PURIFIED_BLOOD_CAULDRON = BlockRegistry.registerBlockAlone("purified_blood_cauldron", () -> new PurifiedBloodCauldronBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50256_), FluidRegistry.NONE_PREDICATE, FluidRegistry.BLOOD_CAULDRON_BEHAVIOR));

    public static <I extends Block> RegistryObject<I> registerBlockAlone(String name, Supplier<I> block) {
        return BLOCKS.register(name, block);
    }

    private static <I extends Block> RegistryObject<I> registerBlockAndItem(String name, Supplier<I> block) {
        RegistryObject registeredBlock = BLOCKS.register(name, block);
        BlockRegistry.registerBlockItem(name, registeredBlock);
        return registeredBlock;
    }

    private static <I extends Block> void registerBlockItem(String name, RegistryObject<I> block) {
        Supplier<Item> item = () -> new BlockItem((Block)block.get(), new Item.Properties());
        RegistryObject<Item> registered = ItemRegistry.registerItem(name, item);
        SoulsWeaponry.ITEM_GROUP_LIST.add(registered);
    }

    private static ToIntFunction<BlockState> createLightLevelFromLitBlockState(int pLightValue) {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? pLightValue : 0;
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

