/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.registry;

import java.util.function.Supplier;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class AttributeRegistry {
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"soulsweapons");
    public static RegistryObject<Attribute> POSTURE_BUILDUP_RESISTANCE = AttributeRegistry.register("posture_buildup_resistance", 0.0, -10000.0, 10000.0);
    public static RegistryObject<Attribute> BASE_POSTURE_INCREASE = AttributeRegistry.register("base_posture_increase", 0.0, -10000.0, 10000.0);
    public static RegistryObject<Attribute> BLEED_BUILDUP_RESISTANCE = AttributeRegistry.register("bleed_buildup_resistance", 0.0, -10000.0, 10000.0);
    public static RegistryObject<Attribute> BLEED_DAMAGE_RESISTANCE = AttributeRegistry.register("bleed_damage_resistance", 0.0, -10000.0, 10000.0);

    public static RegistryObject<Attribute> register(String id, double fallback, double min, double max) {
        return AttributeRegistry.register(id, () -> AttributeRegistry.createClampedAttribute(id, fallback, min, max));
    }

    public static RegistryObject<Attribute> register(String id, Supplier<Attribute> attribute) {
        return ATTRIBUTES.register(id, attribute);
    }

    public static void register(IEventBus bus) {
        ATTRIBUTES.register(bus);
    }

    public static RangedAttribute createClampedAttribute(String attributeName, double fallback, double min, double max) {
        return new RangedAttribute("attribute.soulsweapons." + attributeName, fallback, min, max);
    }
}

