/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.networking.packets.S2C;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.soulsweaponry.client.entitydata.ClientUmbralTrespassData;

public class ShouldDamageRidingSyncS2C {
    private final boolean shouldDamage;

    public ShouldDamageRidingSyncS2C(boolean shouldDamage) {
        this.shouldDamage = shouldDamage;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.shouldDamage);
    }

    public ShouldDamageRidingSyncS2C(FriendlyByteBuf buf) {
        this.shouldDamage = buf.readBoolean();
    }

    public boolean shouldDamageRiding() {
        return this.shouldDamage;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            this.handlePacket(world, this);
        }));
        context.setPacketHandled(true);
    }

    private void handlePacket(ClientLevel world, ShouldDamageRidingSyncS2C packet) {
        ClientUmbralTrespassData.setShouldDamageRiding(packet.shouldDamageRiding());
    }
}

