/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.networking.packets.S2C;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.soulsweaponry.particles.ParticleHandler;

public class FlashParticleS2C {
    private final double x;
    private final double y;
    private final double z;
    private final ParticleHandler.RGB rgb;
    private final float expansion;

    public FlashParticleS2C(double x, double y, double z, ParticleHandler.RGB rgb, float expansion) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.rgb = rgb;
        this.expansion = expansion;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeFloat(this.rgb.getRed());
        buf.writeFloat(this.rgb.getGreen());
        buf.writeFloat(this.rgb.getBlue());
        buf.writeFloat(this.expansion);
    }

    public FlashParticleS2C(FriendlyByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.rgb = new ParticleHandler.RGB(buf.readFloat(), buf.readFloat(), buf.readFloat());
        this.expansion = buf.readFloat();
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public ParticleHandler.RGB getRgb() {
        return this.rgb;
    }

    public float getExpansion() {
        return this.expansion;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            this.handlePacket(world, this);
        }));
        context.setPacketHandled(true);
    }

    private void handlePacket(ClientLevel world, FlashParticleS2C packet) {
        Particle flash = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123747_, packet.getX(), packet.getY(), packet.getZ(), 0.0, 0.0, 0.0);
        flash.m_107259_(new AABB(BlockPos.m_274561_((double)this.x, (double)this.y, (double)this.z)).m_82400_((double)packet.getExpansion()));
        flash.m_107253_(packet.getRgb().getRed(), packet.getRgb().getGreen(), packet.getRgb().getBlue());
    }
}

