/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.networking.packets.S2C;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.soulsweaponry.particles.ChainLightningHandler;
import org.joml.Vector3f;

public class ChainLightningS2C {
    private final Vector3f from;
    private final Vector3f to;

    public ChainLightningS2C(Vector3f from, Vector3f to) {
        this.from = from;
        this.to = to;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_269582_(this.from);
        buf.m_269582_(this.to);
    }

    public ChainLightningS2C(FriendlyByteBuf buf) {
        this.from = buf.m_269394_();
        this.to = buf.m_269394_();
    }

    public Vector3f getFrom() {
        return this.from;
    }

    public Vector3f getTo() {
        return this.to;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            this.handlePacket(world, this);
        }));
        context.setPacketHandled(true);
    }

    private void handlePacket(ClientLevel world, ChainLightningS2C packet) {
        ChainLightningHandler.spawnChainLightning(world, packet.getFrom(), packet.getTo());
    }
}

