/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.networking.packets.S2C;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.soulsweaponry.client.entitydata.ClientBleedData;

public class BleedSyncS2C {
    private final int bleed;

    public BleedSyncS2C(int bleed) {
        this.bleed = bleed;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.bleed);
    }

    public BleedSyncS2C(FriendlyByteBuf buf) {
        this.bleed = buf.readInt();
    }

    public int getBleed() {
        return this.bleed;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            this.handlePacket(world, this);
        }));
        context.setPacketHandled(true);
    }

    private void handlePacket(ClientLevel world, BleedSyncS2C packet) {
        ClientBleedData.setBleed(packet.getBleed());
    }
}

