/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BottleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.registry.FluidRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BottleItem.class})
public class GlassBottleMixin {
    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void interceptUse(Level world, Player user, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> info) {
        BlockHitResult blockHitResult = GlassBottleMixin.raycast(world, user);
        ItemStack itemStack = user.m_21120_(hand);
        BlockPos blockPos = blockHitResult.m_82425_();
        FluidState fluid = world.m_6425_(blockPos);
        if (!world.m_7966_(user, blockPos) || fluid.m_192917_((Fluid)FluidRegistry.FLOWING_PURIFIED_BLOOD.get())) {
            info.setReturnValue((Object)InteractionResultHolder.m_19098_((Object)itemStack));
            info.cancel();
        }
        if (fluid.m_192917_((Fluid)FluidRegistry.STILL_PURIFIED_BLOOD.get())) {
            world.m_6263_(user, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            world.m_142346_((Entity)user, GameEvent.f_157816_, blockPos);
            world.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
            info.setReturnValue((Object)InteractionResultHolder.m_19092_((Object)this.fill(itemStack, user, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43623_)), (boolean)world.m_5776_()));
            info.cancel();
        }
    }

    @Unique
    private ItemStack fill(ItemStack stack, Player player, ItemStack outputStack) {
        player.m_36246_(Stats.f_12982_.m_12902_((Object)((BottleItem)this)));
        return ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)outputStack);
    }

    @Unique
    private static BlockHitResult raycast(Level world, Player player) {
        float f = player.m_146909_();
        float g = player.m_146908_();
        Vec3 vec3d = player.m_146892_();
        float h = Mth.m_14089_((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float i = Mth.m_14031_((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float j = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float k = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float l = i * j;
        float n = h * j;
        Vec3 vec3d2 = vec3d.m_82520_((double)l * 5.0, (double)k * 5.0, (double)n * 5.0);
        return world.m_45547_(new ClipContext(vec3d, vec3d2, ClipContext.Block.OUTLINE, ClipContext.Fluid.SOURCE_ONLY, (Entity)player));
    }
}

