/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.sword;

import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.ModdedSword;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;

public class MehrunesRazor
extends ModdedSword {
    private static final List<EntityType<?>> NO_KILL_ENTITIES = WeaponUtil.getEntityListOffArray(ConfigConstructor.mehrunes_razor_no_instakill_entity_blacklist);

    public MehrunesRazor(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, (int)ConfigConstructor.mehrunes_razor_damage, ConfigConstructor.mehrunes_razor_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.FINAL_WOUNDS);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!this.isDisabled(stack) && !NO_KILL_ENTITIES.contains(target.m_6095_())) {
            float ratio;
            double rand = attacker.m_217043_().m_188500_();
            float f = ratio = target.m_21233_() >= ConfigConstructor.mehrunes_razor_kill_trigger_cap ? ConfigConstructor.mehrunes_razor_kill_chance_over_health_cap : ConfigConstructor.mehrunes_razor_kill_chance_under_health_cap;
            if (rand <= (double)ratio) {
                target.m_6074_();
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_mehrunes_razor;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_mehrunes_razor;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return new String[0];
    }
}

