/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.sword;

import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.soulsweaponry.client.renderer.item.FreyrSwordItemRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.FreyrSwordEntity;
import net.soulsweaponry.entitydata.FreyrSwordSummonData;
import net.soulsweaponry.items.ModdedSword;
import net.soulsweaponry.util.TooltipAbilities;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FreyrSword
extends ModdedSword
implements GeoItem {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public FreyrSword(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, (int)ConfigConstructor.sword_of_freyr_damage, ConfigConstructor.sword_of_freyr_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.SUMMON_WEAPON);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.m_21120_(hand);
        if (this.isDisabled(stack)) {
            this.notifyDisabled((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        FreyrSwordEntity entity = new FreyrSwordEntity(world, user, stack);
        UUID uuid = entity.m_20148_();
        UUID prevUuid = FreyrSwordSummonData.getSummonUuid((LivingEntity)user);
        if (world instanceof ServerLevel) {
            Entity sword;
            ServerLevel serverWorld = (ServerLevel)world;
            if (prevUuid == null) {
                FreyrSwordSummonData.setSummonUuid((LivingEntity)user, uuid);
                prevUuid = uuid;
            }
            if ((sword = serverWorld.m_8791_(prevUuid)) instanceof FreyrSwordEntity) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            user.m_150109_().m_36057_(stack);
            entity.m_20343_(user.m_20185_(), user.m_20186_(), user.m_20189_());
            user.m_6330_(SoundEvents.f_12616_, SoundSource.PLAYERS, 1.0f, 1.0f);
            entity.setStationaryPos(FreyrSwordEntity.NULLISH_POS);
            world.m_7967_((Entity)entity);
            FreyrSwordSummonData.setSummonUuid((LivingEntity)user, uuid);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_sword_of_freyr;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private FreyrSwordItemRenderer renderer = null;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new FreyrSwordItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_sword_of_freyr;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return null;
    }
}

