/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.sword;

import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.IChargeNeeded;
import net.soulsweaponry.items.sword.MoonlightGreatsword;
import net.soulsweaponry.util.TooltipAbilities;

public class BluemoonGreatsword
extends MoonlightGreatsword
implements IChargeNeeded {
    public BluemoonGreatsword(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, (int)ConfigConstructor.bluemoon_greatsword_damage, ConfigConstructor.bluemoon_greatsword_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.NEED_CHARGE, TooltipAbilities.CHARGE);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this.isDisabled(stack)) {
            return super.m_7579_(stack, target, attacker);
        }
        this.addCharge(stack, this.getAddedCharge(stack));
        return super.m_7579_(stack, target, attacker);
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_bluemoon_greatsword;
    }

    @Override
    public int getMaxCharge() {
        return (int)ConfigConstructor.bluemoon_greatsword_charge_needed;
    }

    @Override
    public int getAddedCharge(ItemStack stack) {
        return (int)ConfigConstructor.bluemoon_greatsword_charge_added_post_hit;
    }

    @Override
    public boolean acceptsMoonHeraldEffect(ItemStack stack) {
        return true;
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_bluemoon_greatsword;
    }

    @Override
    public Component[] getAdditionalTooltips() {
        return new Component[0];
    }

    @Override
    public float getProjectileDamage() {
        return ConfigConstructor.bluemoon_greatsword_projectile_damage;
    }

    @Override
    public float getProjectileVelocity() {
        return ConfigConstructor.bluemoon_greatsword_projectile_velocity;
    }
}

