/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.spear;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.noclip.GhostGlaiveEntity;
import net.soulsweaponry.items.BladeDanceItem;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;

public class GlaiveOfHodir
extends BladeDanceItem {
    public GlaiveOfHodir(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, (int)ConfigConstructor.glaive_of_hodir_damage, ConfigConstructor.glaive_of_hodir_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.GHOST_GLAIVE);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        super.m_5551_(stack, world, user, remainingUseTicks);
        if (user instanceof Player) {
            Player playerEntity = (Player)user;
            int i = WeaponUtil.getChargeTime(stack, remainingUseTicks);
            if (i >= 10) {
                stack.m_41622_(3, (LivingEntity)playerEntity, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
                GhostGlaiveEntity entity = new GhostGlaiveEntity(world, (LivingEntity)playerEntity, 10);
                entity.m_36781_(ConfigConstructor.glaive_of_hodir_projectile_damage + (float)WeaponUtil.getEnchantDamageBonus(stack));
                entity.m_20343_(playerEntity.m_20185_(), playerEntity.m_20188_() - (double)0.3f, playerEntity.m_20189_());
                entity.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, 2.0f, 1.0f);
                world.m_7967_((Entity)entity);
                world.m_5594_(playerEntity, playerEntity.m_20183_(), SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 0.5f);
                this.applyItemCooldown(playerEntity, (int)Math.max(ConfigConstructor.glaive_of_hodir_projectile_min_cooldown, ConfigConstructor.glaive_of_hodir_projectile_cooldown - (float)(this.getReduceCooldownEnchantLevel(stack) * 12)));
            }
        }
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_glaive_of_hodir;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_glaive_of_hodir;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.glaive_of_hodir_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.glaive_of_hodir_enchant_reduces_cooldown_ids;
    }

    @Override
    public float getBonusDamagePerStack() {
        return ConfigConstructor.glaive_of_hodir_bonus_damage_per_stack;
    }

    @Override
    public float getBonusAttackSpeedPerStack() {
        return ConfigConstructor.glaive_of_hodir_bonus_attack_speed_per_stack;
    }

    @Override
    public int getMaxStacks() {
        return (int)ConfigConstructor.glaive_of_hodir_max_stacks;
    }

    @Override
    public void applyMaxStacksEffects(LivingEntity entity, ItemStack stack) {
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, (int)ConfigConstructor.glaive_of_hodir_effects_duration, (int)(ConfigConstructor.glaive_of_hodir_resistance_amplifier - 1.0f)));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19617_, (int)ConfigConstructor.glaive_of_hodir_effects_duration, (int)(ConfigConstructor.glaive_of_hodir_absorption_amplifier - 1.0f)));
    }

    @Override
    public int getMaxStacksCooldown() {
        return (int)ConfigConstructor.glaive_of_hodir_add_effects_cooldown;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (this.isDisabled(user.m_21120_(hand))) {
            this.notifyDisabled((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)user.m_21120_(hand));
        }
        ItemStack itemStack = user.m_21120_(hand);
        if (ConfigConstructor.prioritize_off_hand_shield_over_weapon && user.m_21206_().m_41720_() instanceof ShieldItem) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        user.m_6672_(hand);
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }
}

