/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.scythe;

import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.soulsweaponry.client.renderer.item.SoulReaperRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.Forlorn;
import net.soulsweaponry.entity.mobs.SoulReaperGhost;
import net.soulsweaponry.entity.mobs.Soulmass;
import net.soulsweaponry.entitydata.SummonsData;
import net.soulsweaponry.items.ISummonAllies;
import net.soulsweaponry.items.SoulHarvestingItem;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SoulReaper
extends SoulHarvestingItem
implements GeoItem,
ISummonAllies {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SoulReaper(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, (int)ConfigConstructor.soul_reaper_damage, ConfigConstructor.soul_reaper_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.SOUL_RELEASE);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.isDisabled(stack)) {
            this.notifyDisabled((LivingEntity)player);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("kills")) {
            int power = this.getSouls(stack);
            if (player.m_7500_()) {
                power = player.m_217043_().m_216332_(5, 50);
            }
            if (power >= 3 && !world.f_46443_ && this.canSummonEntity((ServerLevel)world, (LivingEntity)player, this.getSummonsListId())) {
                Vec3 vecBlocksAway = player.m_20154_().m_82490_(3.0).m_82549_(player.m_20182_());
                ParticleHandler.particleOutburstMap(world, 50, vecBlocksAway.m_7096_(), vecBlocksAway.m_7098_(), vecBlocksAway.m_7094_(), ParticleEvents.CONJURE_ENTITY_MAP, 1.0f);
                world.m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.NIGHTFALL_SPAWN_EVENT.get(), SoundSource.PLAYERS, 0.8f, 1.0f);
                if (power < 10) {
                    SoulReaperGhost entity = new SoulReaperGhost((EntityType<? extends TamableAnimal>)((EntityType)EntityRegistry.SOUL_REAPER_GHOST.get()), world);
                    entity.m_20343_(vecBlocksAway.f_82479_, player.m_20186_() + (double)0.1f, vecBlocksAway.f_82481_);
                    entity.m_21828_(player);
                    world.m_7967_((Entity)entity);
                    this.saveSummonUuid((LivingEntity)player, entity.m_20148_());
                    if (!player.m_7500_()) {
                        this.addAmount(stack, -3);
                    }
                } else if (player.m_6144_() || power < 30) {
                    Forlorn entity = new Forlorn((EntityType<? extends TamableAnimal>)((EntityType)EntityRegistry.FORLORN.get()), world);
                    entity.m_20343_(vecBlocksAway.f_82479_, player.m_20186_() + (double)0.1f, vecBlocksAway.f_82481_);
                    entity.m_21828_(player);
                    world.m_7967_((Entity)entity);
                    this.saveSummonUuid((LivingEntity)player, entity.m_20148_());
                    if (!player.m_7500_()) {
                        this.addAmount(stack, -10);
                    }
                } else {
                    Soulmass entity = new Soulmass((EntityType<? extends TamableAnimal>)((EntityType)EntityRegistry.SOULMASS.get()), world);
                    entity.m_20343_(vecBlocksAway.f_82479_, player.m_20186_() + (double)0.1f, vecBlocksAway.f_82481_);
                    entity.m_21828_(player);
                    world.m_7967_((Entity)entity);
                    this.saveSummonUuid((LivingEntity)player, entity.m_20148_());
                    if (!player.m_7500_()) {
                        this.addAmount(stack, -30);
                    }
                }
                stack.m_41622_(3, (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21190_(hand));
                return InteractionResultHolder.m_19092_((Object)stack, (boolean)true);
            }
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private PlayState predicate(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().then("low_souls", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private SoulReaperRenderer renderer = null;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new SoulReaperRenderer();
                }
                return this.renderer;
            }
        });
    }

    @Override
    public int getMaxSummons() {
        return (int)ConfigConstructor.soul_reaper_summoned_allies_cap;
    }

    @Override
    public String getSummonsListId() {
        return "SoulReaperSummons";
    }

    @Override
    public void saveSummonUuid(LivingEntity user, UUID summonUuid) {
        SummonsData.addSummonUUID(user, summonUuid, this.getSummonsListId());
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_soul_reaper;
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_soul_reaper;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return null;
    }
}

