/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.scythe;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.SoulHarvestingItem;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.util.ModTags;
import net.soulsweaponry.util.TooltipAbilities;

public class DarkinScythePre
extends SoulHarvestingItem {
    public final int MAX_SOULS = (int)ConfigConstructor.darkin_scythe_max_souls;

    public DarkinScythePre(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, (int)ConfigConstructor.darkin_scythe_damage, ConfigConstructor.darkin_scythe_attack_speed, settings);
        this.getTooltipAbilities().clear();
        this.addTooltipAbility(TooltipAbilities.TRANSFORMATION);
    }

    @Override
    public void handleKill(LivingEntity target, ItemStack stack) {
        int amount;
        int n = amount = target.m_6095_().m_204039_(ModTags.Entities.BOSSES) ? 20 : 1;
        if (target.m_6095_().m_204039_(ModTags.Entities.RANGED_MOBS) || target.m_21205_().m_41720_() instanceof ProjectileWeaponItem || target instanceof AgeableMob) {
            this.addAmount(stack, amount, SoulType.BLUE);
        } else {
            this.addAmount(stack, amount, SoulType.RED);
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (!this.isDisabled(stack) && entity instanceof Player) {
            Player player = (Player)entity;
            if (this.getSouls(stack) >= this.MAX_SOULS && slot == player.m_150109_().f_35977_) {
                if (!world.f_46443_) {
                    ParticleHandler.particleSphere(world, 1000, entity.m_20185_(), entity.m_20186_() + (double)0.1f, entity.m_20189_(), (ParticleOptions)ParticleTypes.f_123744_, 1.0f);
                    ParticleHandler.particleOutburstMap(world, 200, entity.m_20185_(), entity.m_20186_() + (double)0.1f, entity.m_20189_(), ParticleEvents.DAWNBREAKER_MAP, 1.0f);
                }
                world.m_5594_(null, entity.m_20183_(), (SoundEvent)SoundRegistry.DAWNBREAKER_EVENT.get(), SoundSource.HOSTILE, 0.8f, 1.0f);
                Item item = (Item)WeaponRegistry.DARKIN_SCYTHE_PRIME.get();
                switch (this.getDominantType(stack).ordinal()) {
                    case 0: {
                        item = (Item)WeaponRegistry.DARKIN_SCYTHE_PRIME.get();
                        break;
                    }
                    case 1: {
                        item = (Item)WeaponRegistry.SHADOW_ASSASSIN_SCYTHE.get();
                    }
                }
                ItemStack newStack = new ItemStack((ItemLike)item);
                Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
                for (Enchantment enchant : enchants.keySet()) {
                    newStack.m_41663_(enchant, ((Integer)enchants.get(enchant)).intValue());
                }
                player.m_150109_().m_8016_(slot);
                player.m_150109_().m_36040_(slot, newStack);
            }
        }
    }

    public void addAmount(ItemStack stack, int amount, SoulType soulType) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(soulType.id)) {
            stack.m_41783_().m_128405_(soulType.id, stack.m_41783_().m_128451_(soulType.id) + amount);
        } else {
            stack.m_41784_().m_128405_(soulType.id, amount);
        }
    }

    public SoulType getDominantType(ItemStack stack) {
        if (stack.m_41782_()) {
            int red;
            int blue = stack.m_41783_().m_128441_(SoulType.BLUE.id) ? stack.m_41783_().m_128451_(SoulType.BLUE.id) : 0;
            int n = red = stack.m_41783_().m_128441_(SoulType.RED.id) ? stack.m_41783_().m_128451_(SoulType.RED.id) : 0;
            if (blue > red) {
                return SoulType.BLUE;
            }
            return SoulType.RED;
        }
        return SoulType.RED;
    }

    private float getBonusDamage(ItemStack stack) {
        if (this.isDisabled(stack)) {
            return 0.0f;
        }
        float soulPercent = (float)this.getSouls(stack) / (float)this.MAX_SOULS;
        return ConfigConstructor.darkin_scythe_bonus_damage * soulPercent;
    }

    @Override
    public int getSouls(ItemStack stack) {
        int amount = 0;
        if (stack.m_41782_()) {
            if (stack.m_41783_().m_128441_(SoulType.BLUE.id)) {
                amount += stack.m_41783_().m_128451_(SoulType.BLUE.id);
            }
            if (stack.m_41783_().m_128441_(SoulType.RED.id)) {
                amount += stack.m_41783_().m_128451_(SoulType.RED.id);
            }
        }
        return amount;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(this.m_43299_() + this.getBonusDamage(stack)), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.getAttackSpeed(), AttributeModifier.Operation.ADDITION));
            ImmutableMultimap attributeModifiers = builder.build();
            return attributeModifiers;
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_darkin_scythe;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_darkin_scythe;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return null;
    }

    public static enum SoulType {
        RED("red_soul"),
        BLUE("blue_soul");

        final String id;

        private SoulType(String id) {
            this.id = id;
        }
    }
}

