/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.katana;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.noclip.MoonveilWave;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.items.katana.IBleed;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;

public class Moonveil
extends ChargeToUseItem
implements IBleed {
    public Moonveil(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, (int)ConfigConstructor.moonveil_damage, ConfigConstructor.moonveil_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.TRANSIENT_MOONLIGHT, TooltipAbilities.BLEED);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!this.isDisabled(stack)) {
            this.applyBleed(attacker, target);
        }
        return super.m_7579_(stack, target, attacker);
    }

    @Override
    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        int time;
        Player player;
        if (user instanceof Player && !(player = (Player)user).m_36335_().m_41519_((Item)this) && !world.f_46443_ && (time = WeaponUtil.getChargeTime(stack, remainingUseTicks)) >= 10) {
            if (player.m_6144_()) {
                MoonveilWave entity = new MoonveilWave((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.MOONVEIL_VERTICAL.get()), world, user, 15);
                entity.setAreaParticle((ParticleOptions)ParticleRegistry.MOONVEIL_PARTICLE.get());
                entity.setAreaParticleCount(10);
                entity.setDespawnParticle((ParticleOptions)ParticleRegistry.BLUE_FLAME.get());
                entity.m_20343_(player.m_20185_(), player.m_20188_() - 1.0, player.m_20189_());
                entity.setDespawnParticleCount(40);
                entity.setModelRotationX(90);
                entity.setModelTranslationY(1.0f);
                entity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.0f, 1.0f);
                entity.m_36781_(ConfigConstructor.moonveil_vertical_damage + (float)WeaponUtil.getEnchantDamageBonus(stack));
                world.m_7967_((Entity)entity);
                world.m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.MOONVEIL_VERTICAL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                MoonveilWave entity = new MoonveilWave(world, user, 6);
                entity.setAreaParticle((ParticleOptions)ParticleRegistry.MOONVEIL_PARTICLE.get());
                entity.setAreaParticleCount(15);
                entity.setDespawnParticleCount(40);
                entity.setDespawnParticle((ParticleOptions)ParticleRegistry.BLUE_FLAME.get());
                entity.m_20343_(player.m_20185_(), player.m_20188_() - (double)0.3f, player.m_20189_());
                entity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.0f, 1.0f);
                entity.m_36781_(ConfigConstructor.moonveil_wave_damage + (float)WeaponUtil.getEnchantDamageBonus(stack) * 0.8f);
                world.m_7967_((Entity)entity);
                world.m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.MOONVEIL_HORIZONTAL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            stack.m_41622_(3, (LivingEntity)player, p -> p.m_21190_(user.m_7655_()));
            this.applyItemCooldown(player, (int)ConfigConstructor.moonveil_ability_cooldown);
        }
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_moonveil;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_moonveil;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return null;
    }

    @Override
    public int getBleedAmount() {
        return (int)ConfigConstructor.moonveil_bleed_post_hit;
    }
}

