/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.katana;

import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.soulsweaponry.client.renderer.item.BloodlustRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entitydata.BleedData;
import net.soulsweaponry.items.ModdedSword;
import net.soulsweaponry.items.katana.IBleed;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDamageSource;
import net.soulsweaponry.util.IKeybindAbility;
import net.soulsweaponry.util.TooltipAbilities;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Bloodlust
extends ModdedSword
implements IBleed,
GeoItem,
IKeybindAbility {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Bloodlust(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, (int)ConfigConstructor.bloodlust_damage, ConfigConstructor.bloodlust_attack_speed, settings);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
        this.addTooltipAbility(TooltipAbilities.BLOODLUST, TooltipAbilities.BLEED, TooltipAbilities.SCENT_OF_BLOOD);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!this.isDisabled(stack)) {
            this.applyBleed(attacker, target);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                if (player.f_19797_ % 10 == 0) {
                    if (player.m_21023_((MobEffect)EffectRegistry.BLOODTHIRSTY.get())) {
                        this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverWorld), "empowered", "spin");
                    } else {
                        this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverWorld), "empowered", "idle");
                    }
                }
            }
        }
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_bloodlust;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_bloodlust;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return new String[0];
    }

    @Override
    public int getBleedAmount() {
        return (int)ConfigConstructor.bloodlust_bleed_post_hit;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private BloodlustRenderer renderer = null;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new BloodlustRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "empowered", state -> PlayState.STOP).triggerableAnim("spin", RawAnimation.begin().thenPlay("spin")).triggerableAnim("idle", RawAnimation.begin().thenPlay("idle"))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    public void useKeybindAbilityServer(ServerLevel world, ItemStack stack, Player player) {
        player.m_6469_(CustomDamageSource.create((Level)world, CustomDamageSource.BLEED), ConfigConstructor.bloodlust_ability_self_damage);
        BleedData.addBleed((LivingEntity)player, (int)ConfigConstructor.bloodlust_ability_self_bleed);
        stack.m_41622_(1, (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21190_(player.m_7655_()));
        player.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.BLOODTHIRSTY.get(), 300, (int)ConfigConstructor.bloodlust_ability_bloodthirsty_amp));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 400, (int)ConfigConstructor.bloodlust_ability_strength_amp));
        world.m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.BLOOD_LOSS.get(), SoundSource.PLAYERS, 0.75f, 1.0f);
    }

    @Override
    public void useKeybindAbilityClient(ClientLevel world, ItemStack stack, Player player) {
        for (int i = 0; i < 30; ++i) {
            world.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50330_.m_49966_()), player.m_20208_(1.0), player.m_20227_(0.5) + player.m_217043_().m_188500_() * 2.0 - 1.0, player.m_20262_(1.0), 0.0, 0.0, 0.0);
        }
    }
}

