/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.hammer;

import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.soulsweaponry.client.renderer.item.TonitrusRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.ModdedSword;
import net.soulsweaponry.items.abilities.ChainLightning;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Tonitrus
extends ModdedSword
implements GeoItem {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Tonitrus(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, (int)ConfigConstructor.tonitrus_damage, ConfigConstructor.tonitrus_attack_speed, settings);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
        this.addTooltipAbility(TooltipAbilities.STORMVEIL);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!this.isDisabled(stack) && attacker.m_21023_((MobEffect)EffectRegistry.STORMVEIL.get())) {
            MobEffectInstance instance = attacker.m_21124_((MobEffect)EffectRegistry.STORMVEIL.get());
            int amp = instance.m_19564_();
            float radius = ConfigConstructor.tonitrus_stormveil_chain_lightning_range_per_amp * (float)(amp + 1);
            float damage = ConfigConstructor.tonitrus_stormveil_chain_lightning_damage_per_amp * (float)(amp + 1);
            ChainLightning.trigger(attacker.m_9236_(), target, attacker, true, damage, radius);
            if (stack.m_41782_() && stack.m_41783_().m_128441_("Empowered") && stack.m_41783_().m_128471_("Empowered")) {
                LightningBolt lightningEntity = new LightningBolt(EntityType.f_20465_, attacker.m_9236_());
                lightningEntity.m_20343_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                attacker.m_9236_().m_7967_((Entity)lightningEntity);
                stack.m_41784_().m_128379_("Empowered", false);
                attacker.m_21195_((MobEffect)EffectRegistry.STORMVEIL.get());
                attacker.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.STORMVEIL.get(), 20));
                if (attacker instanceof Player) {
                    Player player = (Player)attacker;
                    this.applyEffectCooldown(player, (int)Math.max(ConfigConstructor.tonitrus_ability_max_cooldown, ConfigConstructor.tonitrus_ability_cooldown - (float)(this.getReduceCooldownEnchantLevel(stack) * 10)));
                }
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.m_21120_(hand);
        if (!user.m_21023_((MobEffect)EffectRegistry.COOLDOWN.get())) {
            if (user.m_21023_((MobEffect)EffectRegistry.STORMVEIL.get())) {
                if (stack.m_41782_() && stack.m_41783_().m_128441_("Empowered") && !stack.m_41783_().m_128471_("Empowered")) {
                    stack.m_41784_().m_128379_("Empowered", true);
                    return InteractionResultHolder.m_19096_((Object)stack);
                }
                stack.m_41784_().m_128379_("Empowered", true);
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            stack.m_41784_().m_128379_("Empowered", false);
            stack.m_41622_(1, (LivingEntity)user, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
            int amp = Mth.m_14167_((float)(ConfigConstructor.tonitrus_stormveil_effect_base_amp + (float)WeaponUtil.getEnchantDamageBonus(stack) * ConfigConstructor.tonitrus_stormveil_effect_amp_per_sharpness_enchant_ceiled));
            user.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.STORMVEIL.get(), (int)ConfigConstructor.tonitrus_stormveil_effect_duration, amp));
            world.m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.STORMVEIL_TRIGGER.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                if (player.f_19797_ % 10 == 0) {
                    if (player.m_21023_((MobEffect)EffectRegistry.STORMVEIL.get())) {
                        this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverWorld), "sparks", "charged_bounce");
                    } else {
                        this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverWorld), "sparks", "idle");
                    }
                }
            }
        }
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_tonitrus;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_tonitrus;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.tonitrus_ability_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.tonitrus_ability_enchant_reduces_cooldown_ids;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private TonitrusRenderer renderer = null;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new TonitrusRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "sparks", state -> PlayState.STOP).triggerableAnim("charged_bounce", RawAnimation.begin().thenPlay("charged_bounce")).triggerableAnim("idle", RawAnimation.begin().thenPlay("idle"))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

