/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.hammer;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.noclip.DamagingWarmupEntityEvents;
import net.soulsweaponry.entity.projectile.noclip.FlamePillar;
import net.soulsweaponry.items.UltraHeavyWeapon;
import net.soulsweaponry.registry.EnchantRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.util.DetonateGroundAttributes;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;
import org.apache.logging.log4j.util.TriConsumer;

public class Supernova
extends UltraHeavyWeapon {
    private final DetonateGroundAttributes attributes = new DetonateGroundAttributes(ConfigConstructor.supernova_calculated_fall_base_radius, ConfigConstructor.supernova_calculated_fall_height_increase_radius_modifier, ConfigConstructor.supernova_calculated_fall_target_launch_modifier, ConfigConstructor.supernova_calculated_fall_target_max_launch_power, ConfigConstructor.supernova_calculated_fall_max_radius, ConfigConstructor.supernova_calculated_fall_max_damage, ConfigConstructor.supernova_calculated_fall_height_increase_damage_modifier, ConfigConstructor.supernova_calculated_fall_heal_from_damage_modifier, Map.of((ParticleOptions)ParticleRegistry.SUN_PARTICLE.get(), new Vec3(1.0, 6.0, 1.0)), (TriConsumer<LivingEntity, LivingEntity, Float>)((TriConsumer)(target, user, fallDistance) -> {}), (TriConsumer<LivingEntity, Float, ItemStack>)((TriConsumer)(user, fallDistance, stack) -> {
        int ripples = (int)Math.min(fallDistance.floatValue() * ConfigConstructor.supernova_calculated_fall_height_increase_ripples_modifier, ConfigConstructor.supernova_calculated_fall_max_flame_pillar_ripples);
        WeaponUtil.doConsumerOnCircle(user.m_9236_(), user.m_146908_(), user.m_20182_(), 10.0, ripples, new Vec2(1.5f, 1.75f), (TriConsumer<Vec3, Integer, Float>)((TriConsumer)(vec3d, warmup, yaw) -> {
            FlamePillar pillar = new FlamePillar(user.m_9236_(), (LivingEntity)user, 2.0f, warmup - 6, DamagingWarmupEntityEvents.SPAWN_FIRE);
            pillar.m_146922_(yaw.floatValue());
            pillar.m_36781_(ConfigConstructor.supernova_flame_pillar_damage);
            pillar.m_20343_(vec3d.m_7096_(), vec3d.m_7098_(), vec3d.m_7094_());
            pillar.setParticleAmountMod(1.5f);
            user.m_9236_().m_7967_((Entity)pillar);
            user.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)vec3d), SoundEvents.f_11913_, SoundSource.HOSTILE, 1.0f, 1.0f);
        }));
    }));

    public Supernova(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, (int)ConfigConstructor.supernova_damage, ConfigConstructor.supernova_attack_speed, settings, true);
        this.addTooltipAbility(TooltipAbilities.MOLTEN_EDGE, TooltipAbilities.ARMOR_BREAKER, TooltipAbilities.FIRETHORNS, TooltipAbilities.FLAMEBURST);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!this.isDisabled(stack)) {
            if (attacker.m_217043_().m_188501_() < ConfigConstructor.supernova_firehit_chance) {
                target.m_20254_(Mth.m_14143_((float)ConfigConstructor.supernova_firehit_duration_seconds));
            }
            for (EquipmentSlot slot : new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
                ItemStack armorStack = target.m_6844_(slot);
                if (armorStack.m_41619_() || !armorStack.m_41763_()) continue;
                armorStack.m_41622_((int)ConfigConstructor.supernova_armor_breaker_bonus_stack_damage, target, e -> e.m_21166_(slot));
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    @Override
    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player player = (Player)user;
            int chargeTime = WeaponUtil.getChargeTime(stack, remainingUseTicks);
            if (chargeTime >= 10 && !world.f_46443_) {
                float radius = ConfigConstructor.supernova_molten_metal_radius + (float)EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.STAGGER, (ItemStack)stack);
                float damage = ConfigConstructor.supernova_molten_metal_damage + (float)WeaponUtil.getEnchantDamageBonus(stack);
                int pillars = (int)ConfigConstructor.supernova_ability_flame_pillar_amount;
                WeaponUtil.doConsumerOnLine(world, user.m_146908_() + 90.0f, user.m_20182_(), 4.0, pillars, 1.75f, (TriConsumer<Vec3, Integer, Float>)((TriConsumer)(position, warmup, yaw) -> {
                    FlamePillar pillar = new FlamePillar(world, user, 1.85f + (float)EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.STAGGER, (ItemStack)stack) * 0.5f, (int)warmup, DamagingWarmupEntityEvents.SPAWN_MOLTEN_METAL);
                    pillar.m_146922_(yaw.floatValue());
                    pillar.setOtherAttributes(new DamagingWarmupEntityEvents.OtherAttributes(damage, radius));
                    pillar.m_36781_(ConfigConstructor.supernova_flame_pillar_damage + (float)WeaponUtil.getEnchantDamageBonus(stack));
                    pillar.m_20343_(position.m_7096_(), position.m_7098_(), position.m_7094_());
                    world.m_7967_((Entity)pillar);
                }));
                this.applyItemCooldown(player, Mth.m_14143_((float)Math.max(ConfigConstructor.supernova_ability_min_cooldown, ConfigConstructor.supernova_ability_cooldown - (float)(this.getReduceCooldownEnchantLevel(stack) * 15))));
            }
        }
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_supernova;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_supernova;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.supernova_ability_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.supernova_ability_enchant_reduces_cooldown_ids;
    }

    @Override
    public DetonateGroundAttributes getDetonationAttributes() {
        return this.attributes;
    }

    @Override
    public int getPostureLoss() {
        return (int)ConfigConstructor.supernova_posture_loss;
    }
}

