/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.armor;

import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.soulsweaponry.items.armor.ModdedArmor;
import net.soulsweaponry.util.TooltipAbilities;

public abstract class SetBonusArmor
extends ModdedArmor {
    public SetBonusArmor(ArmorMaterial material, ArmorItem.Type slot, Item.Properties settings) {
        super(material, slot, settings);
        this.addTooltipAbility(TooltipAbilities.SET_BONUS);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player player;
        super.m_6883_(stack, world, entity, slot, selected);
        if (!this.isDisabled(stack) && entity instanceof Player && this.hasFullSet(player = (Player)entity)) {
            for (MobEffectInstance instance : this.getFullSetEffects()) {
                player.m_7292_(instance);
            }
            this.tickAdditionalSetEffects(stack, player);
        }
    }

    protected boolean hasFullSet(Player player) {
        ItemStack boots = player.m_150109_().m_36052_(0);
        ItemStack leggings = player.m_150109_().m_36052_(1);
        ItemStack chestplate = player.m_150109_().m_36052_(2);
        ItemStack helmet = player.m_150109_().m_36052_(3);
        boolean bootsSlot = !boots.m_41619_() && boots.m_41720_() == this.getMatchingBoots();
        boolean leggingsSlot = !leggings.m_41619_() && leggings.m_41720_() == this.getMatchingLegs();
        boolean chestSlot = !chestplate.m_41619_() && chestplate.m_41720_() == this.getMatchingChest();
        boolean helmetSlot = !helmet.m_41619_() && helmet.m_41720_() == this.getMatchingHead();
        return bootsSlot && leggingsSlot && chestSlot && helmetSlot;
    }

    protected abstract void tickAdditionalSetEffects(ItemStack var1, Player var2);

    protected abstract Item getMatchingBoots();

    protected abstract Item getMatchingLegs();

    protected abstract Item getMatchingChest();

    protected abstract Item getMatchingHead();

    public MobEffectInstance[] getFullSetEffects() {
        return new MobEffectInstance[0];
    }

    public Component[] getFullSetAbilities() {
        return new Component[0];
    }
}

