/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.armor;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.soulsweaponry.client.renderer.armor.WitheredArmorRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.armor.ModdedArmor;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.IKeybindAbility;
import net.soulsweaponry.util.TooltipAbilities;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Hallowheart
extends ModdedArmor
implements GeoItem,
IKeybindAbility {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Hallowheart(ArmorMaterial material, ArmorItem.Type type, Item.Properties settings) {
        super(material, type, settings);
        this.addTooltipAbility(TooltipAbilities.UNCEASING, TooltipAbilities.INFECTIOUS);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player player;
        super.m_6883_(stack, world, entity, slot, selected);
        if (entity instanceof Player && this.isSlotActive(player = (Player)entity, EquipmentSlot.CHEST) && player.m_21023_(MobEffects.f_19615_)) {
            player.m_21195_(MobEffects.f_19615_);
        }
    }

    @Override
    public void useKeybindAbilityServer(ServerLevel world, ItemStack stack, Player player) {
        if (!player.m_36335_().m_41519_(stack.m_41720_())) {
            player.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.LIFE_LEACH.get(), (int)ConfigConstructor.withered_chest_life_leach_duration, (int)ConfigConstructor.withered_chest_life_leach_amplifier, false, false));
            player.m_36335_().m_41524_(stack.m_41720_(), (int)Math.max(ConfigConstructor.withered_chest_ability_min_cooldown, ConfigConstructor.withered_chest_ability_cooldown - (float)(this.getReduceCooldownEnchantLevel(stack) * 60)));
            world.m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.DEMON_BOSS_IDLE_EVENT.get(), SoundSource.PLAYERS, 0.75f, 1.0f);
        }
    }

    @Override
    public Component[] getLoreTooltips() {
        return new Component[]{Component.m_237115_((String)"tooltip.soulsweapons.withered_chest.lore.1").m_130940_(ChatFormatting.DARK_GRAY), Component.m_237115_((String)"tooltip.soulsweapons.withered_chest.lore.2").m_130940_(ChatFormatting.DARK_GRAY), Component.m_237115_((String)"tooltip.soulsweapons.withered_chest.lore.3").m_130940_(ChatFormatting.DARK_GRAY), Component.m_237115_((String)"tooltip.soulsweapons.withered_chest.lore.4").m_130940_(ChatFormatting.DARK_GRAY)};
    }

    @Override
    public void useKeybindAbilityClient(ClientLevel world, ItemStack stack, Player player) {
    }

    public PlayState soulsAnimation(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("no_souls"));
        return PlayState.CONTINUE;
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_hallowheart;
    }

    @Override
    public boolean isSlotActive(Player player, EquipmentSlot slot) {
        ItemStack stack = player.m_6844_(slot);
        return !stack.m_41619_() && !this.isDisabled(stack) && stack.m_41720_() instanceof Hallowheart;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_hallowheart;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.withered_chest_ability_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.withered_chest_ability_enchant_reduces_cooldown_ids;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<LivingEntity> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new WitheredArmorRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "souls", 0, this::soulsAnimation)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    public float[] getBasePostureIncrease() {
        return ConfigConstructor.withered_armor_base_posture_increase;
    }

    @Override
    public float[] getPostureBuildupResistances() {
        return ConfigConstructor.withered_armor_posture_buildup_resistances;
    }

    @Override
    public float[] getBleedBuildupResistances() {
        return ConfigConstructor.withered_armor_bleed_buildup_resistances;
    }

    @Override
    public float[] getBleedDamageResistances() {
        return ConfigConstructor.withered_armor_bleed_damage_resistances;
    }
}

