/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.armor;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.armor.Hallowheart;
import net.soulsweaponry.registry.ArmorRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class EnhancedHallowheart
extends Hallowheart {
    public EnhancedHallowheart(ArmorMaterial material, ArmorItem.Type type, Item.Properties settings) {
        super(material, type, settings);
        this.addTooltipAbility(TooltipAbilities.UNBURNABLE, TooltipAbilities.EXALT);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player player;
        super.m_6883_(stack, world, entity, slot, selected);
        if (entity instanceof Player && this.isSlotActive(player = (Player)entity, EquipmentSlot.CHEST)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 100, 0, false, false));
            if (player.m_6060_() && player.f_19797_ % 30 == 0) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 0, false, false));
            }
            if (player.m_21223_() < player.m_21233_() * ConfigConstructor.withered_chest_strength_trigger_percent_1) {
                if (player.m_21223_() < player.m_21233_() * ConfigConstructor.withered_chest_strength_trigger_percent_2) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 40, 1, false, false));
                } else {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 40, 0, false, false));
                }
            }
        }
    }

    @Override
    public boolean isSlotActive(Player player, EquipmentSlot slot) {
        ItemStack stack = player.m_6844_(slot);
        return !stack.m_41619_() && !this.isDisabled(stack) && stack.m_150930_((Item)ArmorRegistry.ENHANCED_WITHERED_CHEST.get());
    }

    @Override
    public Component[] getLoreTooltips() {
        return new Component[]{Component.m_237115_((String)"tooltip.soulsweapons.withered_chest.lore.enhanced.1").m_130940_(ChatFormatting.DARK_GRAY), Component.m_237115_((String)"tooltip.soulsweapons.withered_chest.lore.enhanced.2").m_130940_(ChatFormatting.DARK_GRAY), Component.m_237115_((String)"tooltip.soulsweapons.withered_chest.lore.enhanced.3").m_130940_(ChatFormatting.DARK_GRAY)};
    }

    @Override
    public PlayState soulsAnimation(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("soul_spin"));
        return PlayState.CONTINUE;
    }

    private PlayState heartAnimation(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("idle_heartbeat"));
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        super.registerControllers(controllerRegistrar);
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "heart", 0, this::heartAnimation)});
    }
}

