/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.armor;

import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.soulsweaponry.blocks.WitheredBlock;
import net.soulsweaponry.blocks.WitheredFlower;
import net.soulsweaponry.blocks.WitheredGrass;
import net.soulsweaponry.blocks.WitheredTallFlower;
import net.soulsweaponry.blocks.WitheredTallGrass;
import net.soulsweaponry.client.renderer.armor.ChaosSetRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.armor.ModdedArmor;
import net.soulsweaponry.registry.BlockRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ChaosRobes
extends ModdedArmor
implements GeoItem {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final HashMap<Block, WitheredBlock> turnableBlocks = new HashMap();
    private final HashMap<Block, WitheredGrass> turnableGrass = new HashMap();
    private final HashMap<Block, WitheredTallGrass> turnableTallPlant = new HashMap();

    public ChaosRobes(ArmorMaterial material, ArmorItem.Type type, Item.Properties settings) {
        super(material, type, settings);
        this.addTooltipAbility(TooltipAbilities.CORRUPT_GROUND);
        this.turnableBlocks.put(Blocks.f_50440_, (WitheredBlock)((Object)BlockRegistry.WITHERED_GRASS_BLOCK.get()));
        this.turnableBlocks.put(Blocks.f_50493_, (WitheredBlock)((Object)BlockRegistry.WITHERED_DIRT.get()));
        this.turnableGrass.put(Blocks.f_50034_, (WitheredGrass)BlockRegistry.WITHERED_GRASS.get());
        this.turnableGrass.put(Blocks.f_50035_, (WitheredGrass)BlockRegistry.WITHERED_FERN.get());
        this.turnableGrass.put(Blocks.f_50685_, (WitheredGrass)BlockRegistry.WITHERED_BERRY_BUSH.get());
        this.turnableTallPlant.put(Blocks.f_50359_, (WitheredTallGrass)BlockRegistry.WITHERED_TALL_GRASS.get());
        this.turnableTallPlant.put(Blocks.f_50360_, (WitheredTallGrass)BlockRegistry.WITHERED_LARGE_FERN.get());
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player player;
        super.m_6883_(stack, world, entity, slot, selected);
        if (entity instanceof Player && this.isSlotActive(player = (Player)entity, EquipmentSlot.CHEST)) {
            if (ConfigConstructor.chaos_cape_wither_ground) {
                this.turnBlocks((LivingEntity)player, world, player.m_20183_(), 0);
            }
            if (player.f_19797_ % 40 == 0) {
                for (LivingEntity target : world.m_45976_(LivingEntity.class, player.m_20191_().m_82400_(3.0))) {
                    if (target instanceof Player || target == player) continue;
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 80, 1));
                }
            }
        }
    }

    public void turnBlocks(LivingEntity entity, Level world, BlockPos blockPos, int bonusRadius) {
        if (!entity.m_20096_()) {
            return;
        }
        int f = Math.min(16, 3 + bonusRadius);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (BlockPos blockPos2 : BlockPos.m_121940_((BlockPos)blockPos.m_7918_(-f, -1, -f), (BlockPos)blockPos.m_7918_(f, -1, f))) {
            if (world.m_8055_(blockPos2).m_60795_()) continue;
            for (Block turnBlock : this.turnableBlocks.keySet()) {
                if (world.m_8055_(blockPos2).m_60734_() == turnBlock) {
                    BlockState blockState = this.turnableBlocks.get(turnBlock).m_49966_();
                    if (!blockPos2.m_203195_((Position)entity.m_20182_(), (double)f)) continue;
                    mutable.m_122178_(blockPos2.m_123341_(), blockPos2.m_123342_() + 1, blockPos2.m_123343_());
                    BlockState blockState2 = world.m_8055_((BlockPos)mutable);
                    if (blockState2.m_204336_(BlockTags.f_13037_)) {
                        world.m_46597_((BlockPos)mutable, (BlockState)((WitheredFlower)BlockRegistry.HYDRANGEA.get()).m_49966_().m_61124_((Property)WitheredFlower.CANNOT_TURN, (Comparable)Boolean.valueOf(false)));
                    }
                    for (Block turnGrass : this.turnableGrass.keySet()) {
                        if (!blockState2.m_60713_(turnGrass)) continue;
                        world.m_46597_((BlockPos)mutable, this.turnableGrass.get(turnGrass).m_49966_());
                    }
                    for (Block turnTallPlant : this.turnableTallPlant.keySet()) {
                        if (!blockState2.m_60713_(turnTallPlant)) continue;
                        world.m_7471_((BlockPos)mutable, false);
                        DoublePlantBlock.m_153173_((LevelAccessor)world, (BlockState)this.turnableTallPlant.get(turnTallPlant).m_49966_(), (BlockPos)mutable, (int)2);
                    }
                    if (blockState2.m_204336_(BlockTags.f_13040_)) {
                        world.m_7471_((BlockPos)mutable, false);
                        DoublePlantBlock.m_153173_((LevelAccessor)world, (BlockState)((BlockState)((WitheredTallFlower)BlockRegistry.OLEANDER.get()).m_49966_().m_61124_((Property)WitheredTallFlower.CANNOT_TURN, (Comparable)Boolean.valueOf(false))), (BlockPos)mutable, (int)2);
                    }
                    world.m_46597_(blockPos2, blockState);
                    world.m_186460_(blockPos2, (Block)this.turnableBlocks.get(turnBlock), Mth.m_216271_((RandomSource)entity.m_217043_(), (int)50, (int)90));
                    continue;
                }
                if (world.m_8055_(blockPos2).m_60734_() != this.turnableBlocks.get(turnBlock)) continue;
                WitheredBlock block = (WitheredBlock)world.m_8055_(blockPos2).m_60734_();
                block.resetAge(world.m_8055_(blockPos2), world, blockPos2);
            }
        }
    }

    @Override
    public Component[] getLoreTooltips() {
        return new Component[]{Component.m_237115_((String)"tooltip.soulsweapons.chaos_robes_lore_1").m_130940_(ChatFormatting.DARK_GRAY), Component.m_237115_((String)"tooltip.soulsweapons.chaos_robes_lore_2").m_130940_(ChatFormatting.DARK_GRAY), Component.m_237115_((String)"tooltip.soulsweapons.chaos_robes_lore_3").m_130940_(ChatFormatting.DARK_GRAY), Component.m_237115_((String)"tooltip.soulsweapons.chaos_robes_lore_4").m_130940_(ChatFormatting.DARK_GRAY)};
    }

    private PlayState predicate(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_chaos_robes;
    }

    @Override
    public boolean isSlotActive(Player player, EquipmentSlot slot) {
        ItemStack stack = player.m_6844_(slot);
        return !stack.m_41619_() && !this.isDisabled(stack) && stack.m_41720_() instanceof ChaosRobes;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_chaos_robes;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return new String[0];
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<LivingEntity> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new ChaosSetRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    public float[] getBleedBuildupResistances() {
        return ConfigConstructor.chaos_set_bleed_buildup_resistances;
    }

    @Override
    public float[] getBleedDamageResistances() {
        return ConfigConstructor.chaos_set_bleed_damage_resistances;
    }

    @Override
    public float[] getPostureBuildupResistances() {
        return ConfigConstructor.chaos_set_posture_buildup_resistances;
    }

    @Override
    public float[] getBasePostureIncrease() {
        return ConfigConstructor.chaos_set_base_posture_increase;
    }
}

