/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.armor;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.soulsweaponry.client.renderer.armor.ChaosArmorRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.armor.ChaosCrown;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public class ChaosHelmet
extends ChaosCrown {
    public ChaosHelmet(ArmorMaterial material, ArmorItem.Type type, Item.Properties settings) {
        super(material, type, settings);
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_chaos_helmet;
    }

    @Override
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<LivingEntity> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new ChaosArmorRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    @Override
    public Component[] getLoreTooltips() {
        return new Component[]{Component.m_237115_((String)"tooltip.soulsweapons.chaos_helm_lore_1").m_130940_(ChatFormatting.DARK_GRAY), Component.m_237115_((String)"tooltip.soulsweapons.chaos_helm_lore_2").m_130940_(ChatFormatting.DARK_GRAY), Component.m_237115_((String)"tooltip.soulsweapons.chaos_helm_lore_3").m_130940_(ChatFormatting.DARK_GRAY), Component.m_237115_((String)"tooltip.soulsweapons.chaos_helm_lore_4").m_130940_(ChatFormatting.DARK_GRAY)};
    }

    @Override
    public float[] getBasePostureIncrease() {
        return ConfigConstructor.chaos_armor_base_posture_increase;
    }

    @Override
    public float[] getPostureBuildupResistances() {
        return ConfigConstructor.chaos_armor_posture_buildup_resistances;
    }

    @Override
    public float[] getBleedBuildupResistances() {
        return ConfigConstructor.chaos_armor_bleed_buildup_resistances;
    }

    @Override
    public float[] getBleedDamageResistances() {
        return ConfigConstructor.chaos_armor_bleed_damage_resistances;
    }
}

