/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.armor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.soulsweaponry.client.renderer.armor.ChaosSetRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.armor.ModdedArmor;
import net.soulsweaponry.registry.ArmorRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ChaosCrown
extends ModdedArmor
implements GeoItem {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final UUID LUCK_MODIFIER_UUID = UUID.fromString("ea8c740d-dd7c-4e5e-80aa-41bf5a250f5a");
    private static final AttributeModifier LUCK_MODIFIER = new AttributeModifier(LUCK_MODIFIER_UUID, "Helmet Luck Bonus", (double)ConfigConstructor.chaos_crown_luck_given, AttributeModifier.Operation.ADDITION);
    private static final HashMap<MobEffect, MobEffect> FLIPPABLE_EFFECTS = new HashMap();

    public ChaosCrown(ArmorMaterial material, ArmorItem.Type type, Item.Properties settings) {
        super(material, type, settings);
        this.addTooltipAbility(TooltipAbilities.EMPEROR, TooltipAbilities.EFFECT_REVERSAL);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.isSlotActive(player, EquipmentSlot.HEAD)) {
                if (!player.m_21051_(Attributes.f_22286_).m_22109_(LUCK_MODIFIER)) {
                    player.m_21051_(Attributes.f_22286_).m_22125_(LUCK_MODIFIER);
                }
                if (!player.m_36335_().m_41519_((Item)ArmorRegistry.CHAOS_CROWN.get()) && !player.m_36335_().m_41519_((Item)ArmorRegistry.CHAOS_HELMET.get())) {
                    this.flipEffects(player);
                }
            } else {
                Objects.requireNonNull(player.m_21051_(Attributes.f_22286_)).m_22130_(LUCK_MODIFIER);
            }
        }
    }

    private void flipEffects(Player player) {
        ArrayList statusEffectsCopy = new ArrayList(player.m_21220_());
        ArrayList<MobEffect> effectsToRemove = new ArrayList<MobEffect>();
        boolean triggered = false;
        for (MobEffectInstance instance : statusEffectsCopy) {
            MobEffect effect = instance.m_19544_();
            if (effect.m_19483_() != MobEffectCategory.HARMFUL) continue;
            int duration = (int)((float)instance.m_19557_() / 3.0f);
            int amplifier = (int)((float)instance.m_19564_() / 2.0f);
            MobEffect newEffect = MobEffects.f_19605_;
            for (MobEffect harmful : FLIPPABLE_EFFECTS.keySet()) {
                if (!effect.equals(harmful)) continue;
                newEffect = FLIPPABLE_EFFECTS.get(harmful);
                break;
            }
            effectsToRemove.add(effect);
            triggered = true;
            player.m_7292_(new MobEffectInstance(newEffect, duration, amplifier));
        }
        for (MobEffect effectToRemove : effectsToRemove) {
            player.m_21195_(effectToRemove);
        }
        if (triggered && !player.m_7500_()) {
            player.m_36335_().m_41524_((Item)ArmorRegistry.CHAOS_CROWN.get(), (int)Math.max(ConfigConstructor.chaos_crown_flip_effect_min_cooldown, ConfigConstructor.chaos_crown_flip_effect_cooldown - (float)(this.getReduceCooldownEnchantLevel(player.m_6844_(EquipmentSlot.HEAD)) * 40)));
            player.m_36335_().m_41524_((Item)ArmorRegistry.CHAOS_HELMET.get(), (int)Math.max(ConfigConstructor.chaos_crown_flip_effect_min_cooldown, ConfigConstructor.chaos_crown_flip_effect_cooldown - (float)(this.getReduceCooldownEnchantLevel(player.m_6844_(EquipmentSlot.HEAD)) * 40)));
        }
    }

    @Override
    public Component[] getLoreTooltips() {
        return new Component[]{Component.m_237115_((String)"tooltip.soulsweapons.chaos_crown_lore_1").m_130940_(ChatFormatting.DARK_GRAY), Component.m_237115_((String)"tooltip.soulsweapons.chaos_crown_lore_2").m_130940_(ChatFormatting.DARK_GRAY), Component.m_237115_((String)"tooltip.soulsweapons.chaos_crown_lore_3").m_130940_(ChatFormatting.DARK_GRAY), Component.m_237115_((String)"tooltip.soulsweapons.chaos_crown_lore_4").m_130940_(ChatFormatting.DARK_GRAY)};
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_chaos_crown;
    }

    @Override
    public boolean isSlotActive(Player player, EquipmentSlot slot) {
        ItemStack stack = player.m_6844_(slot);
        return !stack.m_41619_() && !this.isDisabled(stack) && stack.m_41720_() instanceof ChaosCrown;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_chaos_crown;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.chaos_crown_flip_effect_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.chaos_crown_flip_effect_enchant_reduces_cooldown_ids;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<LivingEntity> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new ChaosSetRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    public float[] getBleedBuildupResistances() {
        return ConfigConstructor.chaos_set_bleed_buildup_resistances;
    }

    @Override
    public float[] getBleedDamageResistances() {
        return ConfigConstructor.chaos_set_bleed_damage_resistances;
    }

    @Override
    public float[] getPostureBuildupResistances() {
        return ConfigConstructor.chaos_set_posture_buildup_resistances;
    }

    @Override
    public float[] getBasePostureIncrease() {
        return ConfigConstructor.chaos_set_base_posture_increase;
    }

    static {
        FLIPPABLE_EFFECTS.put(MobEffects.f_19597_, MobEffects.f_19596_);
        FLIPPABLE_EFFECTS.put(MobEffects.f_19599_, MobEffects.f_19598_);
        FLIPPABLE_EFFECTS.put(MobEffects.f_19613_, MobEffects.f_19600_);
        FLIPPABLE_EFFECTS.put(MobEffects.f_19610_, MobEffects.f_19611_);
        FLIPPABLE_EFFECTS.put(MobEffects.f_19612_, MobEffects.f_19618_);
        FLIPPABLE_EFFECTS.put(MobEffects.f_19620_, MobEffects.f_19591_);
    }
}

