/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.armor;

import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.soulsweaponry.client.renderer.armor.ChaosArmorRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.armor.ModdedArmor;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.ArmorRegistry;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Arkenplate
extends ModdedArmor
implements GeoItem {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Arkenplate(ArmorMaterial material, ArmorItem.Type type, Item.Properties settings) {
        super(material, type, settings);
        this.addTooltipAbility(TooltipAbilities.UNBREAKABLE, TooltipAbilities.AFTERSHOCK);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player player;
        super.m_6883_(stack, world, entity, slot, selected);
        if (entity instanceof Player && (player = (Player)entity).m_21223_() <= player.m_21233_() / 2.0f && this.isSlotActive(player, EquipmentSlot.CHEST)) {
            ItemStack chest = player.m_150109_().m_36052_(2);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 40, 1, false, false));
            player.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.MAGIC_RESISTANCE.get(), 40, 1, false, false));
            if (!world.f_46443_ && !player.m_36335_().m_41519_(chest.m_41720_()) && player.m_21188_() != null) {
                this.shockwave(world, player);
            }
        }
    }

    private void shockwave(Level world, Player player) {
        float i = ConfigConstructor.arkenplate_shockwave_knockback;
        ItemStack stack = player.m_150109_().m_36052_(2);
        if (stack == null) {
            return;
        }
        i += (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)stack);
        ParticleHandler.singleParticle(world, (ParticleOptions)ParticleTypes.f_123812_, player.m_20185_(), player.m_20227_(0.5), player.m_20189_(), 0.0, 0.0, 0.0);
        for (Entity entity : world.m_45933_((Entity)player, player.m_20191_().m_82400_(5.0))) {
            LivingEntity target;
            if (!(entity instanceof LivingEntity) || (target = (LivingEntity)entity).m_7307_((Entity)player)) continue;
            if (this.equals(ArmorRegistry.ENHANCED_ARKENPLATE)) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 160, 2));
            }
            target.m_6469_(player.m_269291_().m_269333_((LivingEntity)player), ConfigConstructor.arkenplate_shockwave_damage);
            double x = player.m_20185_() - target.m_20185_();
            double z = player.m_20189_() - target.m_20189_();
            target.m_147240_((double)(i * 0.5f), x, z);
        }
        world.m_5594_(null, player.m_20183_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!player.m_7500_()) {
            player.m_36335_().m_41524_(stack.m_41720_(), (int)Math.max(ConfigConstructor.arkenplate_shockwave_min_cooldown, ConfigConstructor.arkenplate_shockwave_cooldown - (float)(this.getReduceCooldownEnchantLevel(stack) * 20)));
        }
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_arkenplate;
    }

    @Override
    public boolean isSlotActive(Player player, EquipmentSlot slot) {
        ItemStack stack = player.m_6844_(slot);
        return !stack.m_41619_() && !this.isDisabled(stack) && stack.m_41720_() instanceof Arkenplate;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_arkenplate;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.arkenplate_shockwave_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return ConfigConstructor.arkenplate_shockwave_enchant_reduces_cooldown_ids;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<LivingEntity> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new ChaosArmorRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public PlayState predicate(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("no_souls"));
        return PlayState.CONTINUE;
    }

    @Override
    public float[] getBasePostureIncrease() {
        return ConfigConstructor.chaos_armor_base_posture_increase;
    }

    @Override
    public float[] getPostureBuildupResistances() {
        return ConfigConstructor.chaos_armor_posture_buildup_resistances;
    }

    @Override
    public float[] getBleedBuildupResistances() {
        return ConfigConstructor.chaos_armor_bleed_buildup_resistances;
    }

    @Override
    public float[] getBleedDamageResistances() {
        return ConfigConstructor.chaos_armor_bleed_damage_resistances;
    }
}

