/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.ChargeToUseItem;
import net.soulsweaponry.items.IDetonateGround;
import net.soulsweaponry.items.IUltraHeavy;
import net.soulsweaponry.util.TooltipAbilities;

public abstract class UltraHeavyWeapon
extends ChargeToUseItem
implements IUltraHeavy,
IDetonateGround {
    private final boolean isHeavy;

    public UltraHeavyWeapon(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings, boolean isHeavy) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
        this.isHeavy = isHeavy;
        this.addTooltipAbility(TooltipAbilities.HEAVY);
    }

    @Override
    public boolean isHeavy() {
        return this.isHeavy;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!this.isDisabled(stack)) {
            this.gainStrength(attacker);
            this.applyPostureLoss(target);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return ConfigConstructor.ultra_heavy_disables_shields && this.isHeavy;
    }
}

