/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.soulsweaponry.items.IUltraHeavy;
import net.soulsweaponry.items.IUndeadBonus;
import net.soulsweaponry.items.ModdedSword;
import net.soulsweaponry.util.TooltipAbilities;

public class TrickWeapon
extends ModdedSword
implements IUltraHeavy,
IUndeadBonus {
    private final float undeadBonus;
    private final boolean isHeavy;
    private final boolean isFireproof;
    private final boolean isDisabled;
    private final int postureLoss;

    public TrickWeapon(Tier toolMaterial, int damage, float attackSpeed, Item.Properties settings, boolean isHeavy, int postureLoss, float undeadBonus, boolean isFireproof, boolean isDisabled) {
        super(toolMaterial, damage, attackSpeed, settings);
        this.undeadBonus = undeadBonus;
        this.isHeavy = isHeavy;
        this.isFireproof = isFireproof;
        this.isDisabled = isDisabled;
        this.postureLoss = postureLoss;
        if (this.isHeavy()) {
            this.addTooltipAbility(TooltipAbilities.HEAVY);
        }
        if (this.isRighteous()) {
            this.addTooltipAbility(TooltipAbilities.RIGHTEOUS);
        }
    }

    public TrickWeapon(Tier toolMaterial, int damage, float attackSpeed, Item.Properties settings, float undeadBonus, boolean isFireproof, boolean isDisabled) {
        this(toolMaterial, damage, attackSpeed, settings, false, 0, undeadBonus, isFireproof, isDisabled);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this.isHeavy && !this.isDisabled(stack)) {
            this.gainStrength(attacker);
            this.applyPostureLoss(target);
        }
        return super.m_7579_(stack, target, attacker);
    }

    @Override
    public boolean isHeavy() {
        return this.isHeavy;
    }

    @Override
    public int getPostureLoss() {
        return this.postureLoss;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return this.isDisabled;
    }

    @Override
    public boolean m_41475_() {
        return this.isFireproof;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(ItemStack stack) {
        return null;
    }

    @Override
    public boolean isRighteous() {
        return this.undeadBonus > 0.0f;
    }

    @Override
    public float getUndeadBonus(ItemStack stack) {
        return this.undeadBonus;
    }
}

