/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.util.CustomDamageSource;
import net.soulsweaponry.util.DetonateGroundAttributes;

public interface IDetonateGround {
    default public void detonateGroundEffect(LivingEntity user, int amplifier, float fallDistance, Level world, ItemStack stack) {
        float pDistance;
        float expansion = this.getDetonationAttributes().baseExpansion() + this.getDetonationAttributes().expansionMod() * Math.min(this.getDetonationAttributes().maxExpansion(), fallDistance / 10.0f);
        float power = Math.min(this.getDetonationAttributes().maxDamage(), (float)amplifier + fallDistance * this.getDetonationAttributes().fallDistanceDamageMod());
        AABB box = user.m_20191_().m_82400_((double)expansion);
        List entities = world.m_45933_((Entity)user, box);
        for (Entity targets : entities) {
            boolean canDamageTarget;
            LivingEntity livingEntity;
            if (!(targets instanceof LivingEntity) || !(livingEntity = (LivingEntity)targets).m_6084_() || livingEntity.m_7307_((Entity)user) || !(canDamageTarget = livingEntity.m_6469_(CustomDamageSource.create(world, CustomDamageSource.OBLITERATED, (Entity)user), power + EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)livingEntity.m_6336_()))) && !ConfigConstructor.calculated_fall_hits_immune_entities) continue;
            livingEntity.m_5997_(0.0, (double)Math.min(fallDistance * this.getDetonationAttributes().launchMod(), this.getDetonationAttributes().maxLaunchPower()), 0.0);
            float healMod = this.getDetonationAttributes().healMod();
            if (healMod > 0.0f) {
                user.m_5634_(ConfigConstructor.lifesteal_item_base_healing - 1.0f + (ConfigConstructor.lifesteal_item_heal_scales ? power * healMod : 0.0f));
            }
            this.getDetonationAttributes().onEntityDamage().accept((Object)livingEntity, (Object)user, (Object)Float.valueOf(fallDistance));
        }
        this.getDetonationAttributes().onTrigger().accept((Object)user, (Object)Float.valueOf(fallDistance), (Object)stack);
        world.m_5594_(null, user.m_20183_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
        float f = pDistance = fallDistance >= 25.0f ? fallDistance / 25.0f : 1.0f;
        if (!world.f_46443_) {
            ParticleHandler.particleOutburstMap(world, Mth.m_14143_((float)(200.0f * pDistance)), user.m_20185_(), user.m_20186_(), user.m_20189_(), ParticleEvents.BASE_GRAND_SKYFALL_MAP, pDistance);
            for (ParticleOptions particle : this.getDetonationAttributes().particles().keySet()) {
                ParticleHandler.particleOutburst(world, Mth.m_14143_((float)(200.0f * pDistance)), user.m_20185_(), user.m_20186_(), user.m_20189_(), particle, this.getDetonationAttributes().particles().get(particle), pDistance);
            }
        }
    }

    public static boolean triggerCalculateFall(LivingEntity entity, float fallDistance, DamageSource source) {
        if (source.m_276093_(DamageTypes.f_268671_) && entity.m_21023_((MobEffect)EffectRegistry.CALCULATED_FALL.get())) {
            MobEffectInstance effect = entity.m_21124_((MobEffect)EffectRegistry.CALCULATED_FALL.get());
            Item item = (Item)WeaponRegistry.COMET_SPEAR.get();
            ItemStack stack = new ItemStack((ItemLike)item);
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack itemStack = entity.m_21120_(hand);
                if (!(stack.m_41720_() instanceof IDetonateGround)) continue;
                item = stack.m_41720_();
                stack = itemStack;
            }
            ((IDetonateGround)item).detonateGroundEffect(entity, effect.m_19564_(), fallDistance, entity.m_9236_(), stack);
            entity.m_21195_((MobEffect)EffectRegistry.CALCULATED_FALL.get());
            entity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.CALCULATED_FALL.get(), 10, 0));
            return true;
        }
        return false;
    }

    public DetonateGroundAttributes getDetonationAttributes();
}

