/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.IChargeNeeded;
import net.soulsweaponry.items.ModdedSword;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.WeaponUtil;

public abstract class ChargeToUseItem
extends ModdedSword {
    public ChargeToUseItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        IChargeNeeded charge;
        if (this.isDisabled(user.m_21120_(hand))) {
            this.notifyDisabled((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)user.m_21120_(hand));
        }
        ItemStack itemStack = user.m_21120_(hand);
        if (ConfigConstructor.prioritize_off_hand_shield_over_weapon && user.m_21206_().m_41720_() instanceof ShieldItem) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        ChargeToUseItem chargeToUseItem = this;
        if (chargeToUseItem instanceof IChargeNeeded && !(charge = (IChargeNeeded)((Object)chargeToUseItem)).isCharged(itemStack) && !user.m_7500_() && charge.acceptsMoonHeraldEffect(itemStack) && !user.m_21023_((MobEffect)EffectRegistry.MOON_HERALD.get())) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        user.m_6672_(hand);
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }

    public int getChargeTime(ItemStack stack, int remainingUseTicks) {
        int i = WeaponUtil.isModLoaded("epicfight") ? Integer.MAX_VALUE - remainingUseTicks : this.m_8105_(stack) - remainingUseTicks;
        return i;
    }

    public abstract void m_5551_(ItemStack var1, Level var2, LivingEntity var3, int var4);
}

