/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.soulsweaponry.items.ModdedSword;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;

public abstract class BladeDanceItem
extends ModdedSword {
    public BladeDanceItem(Tier toolMaterial, int attackDamage, float ingameAttackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, ingameAttackSpeed, settings);
        this.addTooltipAbility(TooltipAbilities.GLAIVE_DANCE);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this.isDisabled(stack)) {
            return super.m_7579_(stack, target, attacker);
        }
        int amp = attacker.m_21023_((MobEffect)EffectRegistry.BLADE_DANCE.get()) ? attacker.m_21124_((MobEffect)EffectRegistry.BLADE_DANCE.get()).m_19564_() + 1 : 0;
        amp = Math.min(amp, this.getMaxStacks() - 1);
        attacker.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.BLADE_DANCE.get(), 160, amp));
        if (!WeaponUtil.isFightModLoaded() && amp + 1 == this.getMaxStacks()) {
            int counter = 0;
            if (stack.m_41782_()) {
                counter = stack.m_41783_().m_128441_("AOECounter") ? stack.m_41783_().m_128451_("AOECounter") : 0;
            }
            stack.m_41784_().m_128405_("AOECounter", counter + 1);
            if (stack.m_41783_().m_128451_("AOECounter") >= 3) {
                Level entity2;
                for (Level entity2 : attacker.m_9236_().m_45933_((Entity)attacker, attacker.m_20191_().m_82377_(2.0, 1.0, 2.0))) {
                    if (!(entity2 instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity2;
                    living.m_6469_(attacker.m_269291_().m_269333_(attacker), this.getTotalDamage(stack));
                }
                entity2 = attacker.m_9236_();
                if (entity2 instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)entity2;
                    for (int i = 0; i < 360; i += 30) {
                        float r = 2.0f;
                        double x0 = attacker.m_20185_();
                        double z0 = attacker.m_20189_();
                        double x = x0 + (double)r * Math.cos((double)i * Math.PI / 180.0);
                        double z = z0 + (double)r * Math.sin((double)i * Math.PI / 180.0);
                        serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123766_, x, attacker.m_20227_(0.5), z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                stack.m_41783_().m_128405_("AOECounter", 0);
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.getTotalDamage(stack), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.getTotalAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
            ImmutableMultimap attributeModifiers = builder.build();
            return attributeModifiers;
        }
        return super.m_7167_(slot);
    }

    public static void updateBladeDanceItem(ItemStack stack, int effectAmplifier) {
        Item item = stack.m_41720_();
        if (item instanceof BladeDanceItem) {
            BladeDanceItem item2 = (BladeDanceItem)item;
            stack.m_41784_().m_128350_("BladeDanceBonusDamage", item2.getBonusDamagePerStack() * (float)effectAmplifier);
            stack.m_41784_().m_128350_("BladeDanceBonusAttackSpeed", item2.getBonusAttackSpeedPerStack() * (float)effectAmplifier);
        }
    }

    public abstract float getBonusDamagePerStack();

    public abstract float getBonusAttackSpeedPerStack();

    public abstract int getMaxStacks();

    public abstract void applyMaxStacksEffects(LivingEntity var1, ItemStack var2);

    public abstract int getMaxStacksCooldown();

    public float getTotalDamage(ItemStack stack) {
        float damage = this.m_43299_();
        if (stack.m_41782_() && stack.m_41783_().m_128441_("BladeDanceBonusDamage")) {
            damage += stack.m_41783_().m_128457_("BladeDanceBonusDamage");
        }
        return damage;
    }

    public float getTotalAttackSpeed(ItemStack stack) {
        float attackSpeed = this.getAttackSpeed();
        if (stack.m_41782_() && stack.m_41783_().m_128441_("BladeDanceBonusAttackSpeed")) {
            attackSpeed += stack.m_41783_().m_128457_("BladeDanceBonusAttackSpeed");
        }
        return attackSpeed;
    }
}

