/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.events;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.soulsweaponry.api.entitystats.EntityBleed;
import net.soulsweaponry.api.entitystats.EntityPosture;
import net.soulsweaponry.api.entitystats.EntityStatsUtil;
import net.soulsweaponry.api.trickweapon.TrickWeaponUtil;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entitydata.BleedData;
import net.soulsweaponry.entitydata.ParryData;
import net.soulsweaponry.entitydata.PostureData;
import net.soulsweaponry.entitydata.ReturningProjectileData;
import net.soulsweaponry.entitydata.TargetPostureData;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.SoundRegistry;

@Mod.EventBusSubscriber(modid="soulsweapons", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModEvents {
    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new EntityStatsUtil());
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        TrickWeaponUtil.loadMappings(event.getServer());
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().reviveCaps();
            Player oldPlayer = event.getOriginal();
            Player newPlayer = event.getEntity();
            PostureData.setPosture((LivingEntity)newPlayer, PostureData.getPosture((LivingEntity)oldPlayer));
            CompoundTag oldData = oldPlayer.getPersistentData();
            CompoundTag newData = newPlayer.getPersistentData();
            if (oldData.m_128441_("returning_projectile_uuid") && newPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)newPlayer;
                UUID uuid = oldData.m_128342_("returning_projectile_uuid");
                newData.m_128362_("returning_projectile_uuid", uuid);
                ReturningProjectileData.syncData(uuid, serverPlayerEntity);
            }
            event.getOriginal().invalidateCaps();
        }
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            Player player = event.player;
            int parryFrames = ParryData.getParryFrames(player);
            if (parryFrames >= 1) {
                ParryData.addParryFrames(player, 1);
                player.m_21253_();
            }
            if (player.m_21214_() != null) {
                TargetPostureData.updateTargetPosture((LivingEntity)player, player.m_21214_());
            } else {
                TargetPostureData.resetValues((LivingEntity)player);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingEntityTicks(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        int posture = PostureData.getPosture(entity);
        int bleed = BleedData.getBleed(entity);
        if (!EntityPosture.isPostureDisabled(entity) && posture >= EntityPosture.getMaxPostureLoss(entity) && EntityPosture.getMaxPostureLoss(entity) != 0) {
            if (!entity.m_21023_((MobEffect)EffectRegistry.POSTURE_BREAK.get())) {
                entity.m_9236_().m_5594_(null, entity.m_20183_(), (SoundEvent)SoundRegistry.POSTURE_BREAK_EVENT.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            entity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.POSTURE_BREAK.get(), 60, 1));
            PostureData.setPosture(entity, 0);
        }
        if (!EntityBleed.isBleedDisabled(entity) && bleed >= EntityBleed.getMaxBleed(entity)) {
            EntityBleed.triggerBloodLoss(entity);
        }
        if (!entity.m_9236_().f_46443_) {
            if (entity.f_19797_ % (int)ConfigConstructor.posture_loss_reduction_interval == 0 && posture > 0) {
                PostureData.reducePosture(entity, (int)ConfigConstructor.posture_loss_reduction_amount);
            }
            if (entity.f_19797_ % (int)ConfigConstructor.bleed_reduction_interval == 0 && bleed > 0) {
                BleedData.reduceBleed(entity, (int)ConfigConstructor.bleed_reduction_amount);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        Level level = event.getLevel();
        InteractionHand hand = event.getHand();
        ItemStack stack = event.getItemStack();
        if (!(stack.m_150930_(Items.f_42589_) || stack.m_150930_(Items.f_42736_) || stack.m_150930_(Items.f_42739_) || stack.m_150930_(Items.f_42738_))) {
            return;
        }
        Potion potion = PotionUtils.m_43579_((ItemStack)stack);
        if (potion == null || !potion.equals(EffectRegistry.CHUNGUS_TONIC_POTION.get())) {
            return;
        }
        if (!level.f_46443_) {
            ItemStack updated = stack.m_41777_();
            updated.m_41784_().m_128405_("CustomPotionColor", EffectRegistry.randomVibrantRGBA());
            player.m_21008_(hand, updated);
        }
    }
}

