/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entitydata;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.soulsweaponry.api.entitystats.EntityPosture;
import net.soulsweaponry.networking.ModMessages;
import net.soulsweaponry.networking.packets.S2C.MaxPostureSyncS2C;
import net.soulsweaponry.networking.packets.S2C.PostureSyncS2C;

public class PostureData {
    public static final String POSTURE_ID = "posture";
    public static final String MAX_POSTURE_ID = "max_posture";

    public static void addPostureLoss(LivingEntity entity, int amount) {
        int posture;
        if (EntityPosture.isPostureDisabled(entity) || entity.m_21224_() || entity.m_9236_().f_46443_) {
            return;
        }
        int newAmount = EntityPosture.getPostureLoss(entity, amount);
        CompoundTag nbt = entity.getPersistentData();
        if (!nbt.m_128441_(POSTURE_ID)) {
            nbt.m_128405_(POSTURE_ID, 0);
        }
        posture = (posture = nbt.m_128451_(POSTURE_ID)) < 0 ? 0 : (posture += newAmount);
        nbt.m_128405_(POSTURE_ID, posture);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            PostureData.syncData(posture, serverPlayer);
        }
    }

    public static int getPosture(LivingEntity target) {
        if (!target.getPersistentData().m_128441_(POSTURE_ID)) {
            target.getPersistentData().m_128405_(POSTURE_ID, 0);
        }
        return target.getPersistentData().m_128451_(POSTURE_ID);
    }

    public static void reducePosture(LivingEntity entity, int amount) {
        PostureData.addPostureLoss(entity, -amount);
    }

    public static void setPosture(LivingEntity entity, int amount) {
        CompoundTag nbt = entity.getPersistentData();
        nbt.m_128405_(POSTURE_ID, amount);
        if (entity instanceof ServerPlayer) {
            PostureData.syncData(amount, (ServerPlayer)entity);
        }
    }

    public static void syncData(int data, ServerPlayer entity) {
        ModMessages.sendToPlayer(new PostureSyncS2C(data), entity);
    }

    public static int getMaxPosture(Player target) {
        if (!target.getPersistentData().m_128441_(MAX_POSTURE_ID)) {
            target.getPersistentData().m_128405_(MAX_POSTURE_ID, 0);
        }
        return target.getPersistentData().m_128451_(MAX_POSTURE_ID);
    }

    public static void updateMaxPosture(Player entity, int amount) {
        CompoundTag nbt = entity.getPersistentData();
        nbt.m_128405_(MAX_POSTURE_ID, amount);
        if (entity instanceof ServerPlayer) {
            PostureData.syncMaxPosture(amount, (ServerPlayer)entity);
        }
    }

    public static void syncMaxPosture(int data, ServerPlayer entity) {
        ModMessages.sendToPlayer(new MaxPostureSyncS2C(data), entity);
    }
}

