/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entitydata;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.networking.ModMessages;
import net.soulsweaponry.networking.packets.S2C.ParrySyncS2C;

public class ParryData {
    public static final String PARRY_FRAMES_ID = "parry_frames";
    public static final int MAX_PARRY_FRAMES = (int)ConfigConstructor.shield_parry_max_animation_frames;

    public static int addParryFrames(Player player, int amount) {
        int frame;
        CompoundTag nbt = player.getPersistentData();
        if (!nbt.m_128441_(PARRY_FRAMES_ID)) {
            nbt.m_128405_(PARRY_FRAMES_ID, 0);
        }
        frame = (frame = nbt.m_128451_(PARRY_FRAMES_ID)) >= MAX_PARRY_FRAMES ? 0 : (frame += amount);
        nbt.m_128405_(PARRY_FRAMES_ID, frame);
        if (player instanceof ServerPlayer) {
            ParryData.syncFrames(frame, (ServerPlayer)player);
        }
        return frame;
    }

    public static int setParryFrames(Player player, int amount) {
        CompoundTag nbt = player.getPersistentData();
        nbt.m_128405_(PARRY_FRAMES_ID, amount);
        if (player instanceof ServerPlayer) {
            ParryData.syncFrames(amount, (ServerPlayer)player);
        }
        return amount;
    }

    public static int getParryFrames(Player player) {
        if (!player.getPersistentData().m_128441_(PARRY_FRAMES_ID)) {
            player.getPersistentData().m_128405_(PARRY_FRAMES_ID, 0);
        }
        return player.getPersistentData().m_128451_(PARRY_FRAMES_ID);
    }

    public static boolean successfulParry(Player player, boolean checkIfCanBeParried, DamageSource source) {
        int frames = ParryData.getParryFrames(player);
        boolean bl = true;
        if (checkIfCanBeParried) {
            bl = !source.m_269533_(DamageTypeTags.f_276146_);
        }
        return frames >= 1 && (float)frames <= ConfigConstructor.shield_parry_frames && bl;
    }

    public static void syncFrames(int frames, ServerPlayer player) {
        ModMessages.sendToPlayer(new ParrySyncS2C(frames), player);
    }
}

