/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class BlackflameSnakeUtil {
    public static List<List<Vec3>> getCurvedPositions(float entityYaw, float radius, Vec3 start, Vec3 end) {
        ArrayList<List<Vec3>> curvedPositions = new ArrayList<List<Vec3>>();
        curvedPositions.add(BlackflameSnakeUtil.getPositionsFromSide(true, entityYaw, radius, start, end));
        curvedPositions.add(BlackflameSnakeUtil.getPositionsFromSide(false, entityYaw, radius, start, end));
        return curvedPositions;
    }

    public static List<Vec3> getAllPositions(float yaw, float radius, Vec3 start, Vec3 end) {
        ArrayList<Vec3> positions = new ArrayList<Vec3>();
        double ra = Math.toRadians(yaw += 90.0f);
        Vec3 s = start.m_82520_(Math.cos(ra) * (double)radius, 0.0, Math.sin(ra) * (double)radius);
        Vec3 endLeft = null;
        Vec3 endRight = null;
        for (int i = 90; i < 270; ++i) {
            if (i % 8 != 0) continue;
            double rad = Math.toRadians(yaw + (float)i);
            double x = (double)radius * Math.cos(rad);
            double z = (double)radius * Math.sin(rad);
            Vec3 pos = new Vec3(x, 0.0, z).m_82549_(s);
            if (i == 264) {
                endLeft = pos;
            }
            if (i == 96) {
                endRight = pos;
            }
            positions.add(pos);
        }
        if (endLeft != null && endRight != null) {
            Vec3 start1 = endLeft;
            Vec3 between = new Vec3(end.m_7096_() - start1.m_7096_(), end.m_7098_() - start1.m_7098_(), end.m_7094_() - start1.m_7094_());
            int len = Mth.m_14107_((double)between.m_82553_());
            for (int i = 0; i < len; ++i) {
                start1 = start1.m_82549_(between.m_82490_(1.0 / (double)len));
                positions.add(new Vec3(start1.m_7096_(), start1.m_7098_(), start1.m_7094_()));
            }
            Vec3 start2 = endRight;
            Vec3 between2 = new Vec3(end.m_7096_() - start2.m_7096_(), end.m_7098_() - start2.m_7098_(), end.m_7094_() - start2.m_7094_());
            int len2 = Mth.m_14107_((double)between2.m_82553_());
            for (int i = 0; i < len2; ++i) {
                start2 = start2.m_82549_(between2.m_82490_(1.0 / (double)len));
                positions.add(new Vec3(start2.m_7096_(), start2.m_7098_(), start2.m_7094_()));
            }
        }
        return positions;
    }

    public static List<Vec3> getPositionsFromSide(boolean leftSide, float yaw, float radius, Vec3 start, Vec3 end) {
        ArrayList<Vec3> positions = new ArrayList<Vec3>();
        double ra = Math.toRadians(yaw += 90.0f);
        Vec3 s = start.m_82520_(Math.cos(ra) * (double)radius, 0.0, Math.sin(ra) * (double)radius);
        Vec3 endPos = null;
        int i = 180;
        while (leftSide ? i < 270 : i > 90) {
            if (i % 8 == 0) {
                double rad = Math.toRadians(yaw + (float)i);
                double x = (double)radius * Math.cos(rad);
                double z = (double)radius * Math.sin(rad);
                Vec3 pos = new Vec3(x, 0.0, z).m_82549_(s);
                if (i == (leftSide ? 264 : 96)) {
                    endPos = pos;
                }
                positions.add(pos);
            }
            if (leftSide) {
                ++i;
                continue;
            }
            --i;
        }
        if (endPos != null) {
            positions.addAll(BlackflameSnakeUtil.getPosOfLine(endPos, end));
        }
        return positions;
    }

    public static List<Vec3> getPosOfLine(Vec3 targetPos, Vec3 end) {
        ArrayList<Vec3> positions = new ArrayList<Vec3>();
        Vec3 between = new Vec3(end.m_7096_() - targetPos.m_7096_(), end.m_7098_() - targetPos.m_7098_(), end.m_7094_() - targetPos.m_7094_());
        int len = Mth.m_14107_((double)between.m_82553_());
        for (int j = 0; j < len; ++j) {
            targetPos = targetPos.m_82549_(between.m_82490_(1.0 / (double)len));
            positions.add(new Vec3(targetPos.m_7096_(), targetPos.m_7098_(), targetPos.m_7094_()));
        }
        return positions;
    }
}

