/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile.noclip;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.soulsweaponry.entity.projectile.noclip.DamagingNoClipEntity;
import net.soulsweaponry.registry.EntityRegistry;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class MoonveilWave
extends DamagingNoClipEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> MODEL_ROTATION_X = SynchedEntityData.m_135353_(MoonveilWave.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> MODEL_TRANSLATION_Y = SynchedEntityData.m_135353_(MoonveilWave.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<String> TEXTURE_ID = SynchedEntityData.m_135353_(MoonveilWave.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public MoonveilWave(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
    }

    public MoonveilWave(EntityType<? extends AbstractArrow> entityType, Level world, LivingEntity owner, int maxAge) {
        super(entityType, world, owner, maxAge);
    }

    public MoonveilWave(Level world, LivingEntity owner, int maxAge) {
        super((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.MOONVEIL_HORIZONTAL.get()), world, owner, maxAge);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < this.getAreaParticleCount(); ++i) {
                this.m_9236_().m_7106_(this.getAreaParticle(), this.m_20208_(0.75), this.m_20187_(), this.m_20262_(0.75), 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_142036_() {
        super.m_142036_();
        for (int i = 0; i < this.getDespawnParticleCount(); ++i) {
            double d = 1.0;
            float div = 4.0f;
            double e = this.m_9236_().m_213780_().m_188500_() / (double)div - d / (double)(div * 2.0f);
            double f = this.m_9236_().m_213780_().m_188500_() / (double)div - d / (double)(div * 2.0f);
            double g = this.m_9236_().m_213780_().m_188500_() / (double)div - d / (double)(div * 2.0f);
            this.m_9236_().m_7106_(this.getDespawnParticle(), this.m_20208_(0.75), this.m_20187_(), this.m_20262_(0.75), e, f, g);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MODEL_ROTATION_X, (Object)0);
        this.f_19804_.m_135372_(MODEL_TRANSLATION_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TEXTURE_ID, (Object)"moonveil_wave");
    }

    public void setModelRotationX(int degrees) {
        this.f_19804_.m_135381_(MODEL_ROTATION_X, (Object)degrees);
    }

    public int getModelRotationX() {
        return (Integer)this.f_19804_.m_135370_(MODEL_ROTATION_X);
    }

    public void setModelTranslationY(float translationY) {
        this.f_19804_.m_135381_(MODEL_TRANSLATION_Y, (Object)Float.valueOf(translationY));
    }

    public float getModelTranslationY() {
        return ((Float)this.f_19804_.m_135370_(MODEL_TRANSLATION_Y)).floatValue();
    }

    public void setTextureId(String textureId) {
        this.f_19804_.m_135381_(TEXTURE_ID, (Object)textureId);
    }

    public String getTextureId() {
        return (String)this.f_19804_.m_135370_(TEXTURE_ID);
    }

    public void setTextureId(MoonveilTextures textureId) {
        this.setTextureId(textureId.toString().toLowerCase());
    }

    @Override
    public void applyDamageEffects(boolean wasHit, LivingEntity target) {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public static enum MoonveilTextures {
        MOONVEIL_WAVE,
        MOONLIGHT_PROJECTILE_BIG;

    }
}

