/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile.noclip;

import java.util.List;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.noclip.NoClipEntity;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.util.CustomDamageSource;
import net.soulsweaponry.util.ModTags;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class MoltenMetal
extends NoClipEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public MoltenMetal(EntityType<? extends MoltenMetal> entityType, Level world) {
        super(entityType, world);
    }

    public MoltenMetal(Level world, float width, float height) {
        super((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.MOLTEN_METAL.get()), world);
        this.setBoundingBoxWidth(width);
        this.setBoundingBoxHeight(height);
        this.setDespawnParticle((ParticleOptions)ParticleTypes.f_123756_);
        this.setDespawnParticleCount(50);
        this.setAreaParticle((ParticleOptions)ParticleTypes.f_123756_);
    }

    public MoltenMetal(Level world, float width) {
        super((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.MOLTEN_METAL.get()), world);
        this.setBoundingBoxWidth(width);
        this.setBoundingBoxHeight(0.3f + (float)world.f_46441_.m_216332_(-20, 20) * 0.01f);
        this.setDespawnParticle((ParticleOptions)ParticleTypes.f_123756_);
        this.setDespawnParticleCount(50);
        this.setAreaParticle((ParticleOptions)ParticleTypes.f_123756_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % this.f_19796_.m_216332_(20, 70) == 0) {
            this.m_5496_(SoundEvents.f_12032_, 1.0f, 1.0f);
            if (this.f_19797_ < this.getMaxAge() - 80) {
                this.m_5496_(SoundEvents.f_12030_, 1.0f, 1.0f);
            }
        }
        if (this.m_9236_().f_46443_ && this.f_19797_ % 3 == 0) {
            double d = this.m_20208_(0.5);
            double e = this.m_20186_();
            double f = this.m_20262_(0.5);
            this.m_9236_().m_7106_(this.getAreaParticle(), d, e, f, 0.0, 0.0, 0.0);
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(0.2));
        for (LivingEntity livingEntity : list) {
            if (!livingEntity.m_6084_() || livingEntity.m_20147_() || this.m_19749_() != null && (livingEntity.m_7307_(this.m_19749_()) || this.m_150171_((Entity)livingEntity))) continue;
            livingEntity.m_6469_(CustomDamageSource.create(this.m_9236_(), CustomDamageSource.PLAYER_FIRE, (Entity)this, this.m_19749_()), (float)this.m_36789_());
            livingEntity.m_20254_((int)ConfigConstructor.supernova_molten_metal_fire_seconds);
            ItemStack stack = livingEntity.m_21206_();
            if (!(livingEntity instanceof Player)) continue;
            Player player = (Player)livingEntity;
            if (!stack.m_204117_(ModTags.Items.SHIELDS) || player.m_36335_().m_41519_(stack.m_41720_())) continue;
            player.m_36384_(true);
            stack.m_41622_((int)ConfigConstructor.supernova_molten_metal_shield_damage, (LivingEntity)player, p -> p.m_21190_(InteractionHand.OFF_HAND));
        }
        if (this.f_19797_ > this.getMaxAge() || this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60795_()) {
            this.discardParticles();
            this.m_146870_();
        }
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12031_, this.m_5720_(), 1.0f, 0.75f, false);
        ParticleHandler.particleOutburstMap(this.m_9236_(), 40, this.m_20185_(), this.m_20186_(), this.m_20189_(), Map.of(ParticleTypes.f_123755_, new Vec3(1.0, 10.0, 1.0), ParticleTypes.f_123744_, new Vec3(1.0, 10.0, 1.0), ParticleTypes.f_123756_, new Vec3(1.0, 10.0, 1.0)), 1.0f);
    }

    private void discardParticles() {
        for (int i = 0; i < this.getDespawnParticleCount(); ++i) {
            double d = this.m_20208_(0.5);
            double e = this.m_20186_();
            double f = this.m_20262_(0.5);
            this.m_9236_().m_7106_(this.getDespawnParticle(), d, e, f, 0.0, 0.0, 0.0);
        }
        this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12031_, this.m_5720_(), 1.0f, 0.75f, false);
    }

    @Override
    public int getMaxAge() {
        return (int)ConfigConstructor.supernova_molten_metal_max_age_ticks;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

