/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile.noclip;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.noclip.DamagingNoClipEntity;
import net.soulsweaponry.entitydata.PostureData;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class GhostGlaiveEntity
extends DamagingNoClipEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public GhostGlaiveEntity(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
        this.setAreaParticle((ParticleOptions)ParticleRegistry.SUN_PARTICLE.get());
        this.setAreaParticleCount(20);
    }

    public GhostGlaiveEntity(Level world, LivingEntity owner, int maxAge) {
        super((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.GHOST_GLAIVE_TYPE.get()), world, owner, maxAge);
        this.setAreaParticle((ParticleOptions)ParticleRegistry.SUN_PARTICLE.get());
        this.setAreaParticleCount(20);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < this.getAreaParticleCount(); ++i) {
                this.m_9236_().m_7106_(this.getAreaParticle(), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void applyDamageEffects(boolean wasHit, LivingEntity target) {
        PostureData.addPostureLoss(target, (int)ConfigConstructor.glaive_of_hodir_projectile_posture_loss);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

