/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile.noclip;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.entity.projectile.noclip.DamagingWarmupEntity;
import net.soulsweaponry.entity.projectile.noclip.MoltenMetal;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.ParticleRegistry;

public class DamagingWarmupEntityEvents {
    public static final Map<Integer, BiConsumer<DamagingWarmupEntity, OtherAttributes>> EVENTS = new HashMap<Integer, BiConsumer<DamagingWarmupEntity, OtherAttributes>>();
    private static int idCounter = 0;
    public static final int SPAWN_FIRE = DamagingWarmupEntityEvents.getEventId();
    public static final int SPAWN_MOLTEN_METAL = DamagingWarmupEntityEvents.getEventId();
    public static final int SPAWN_LIGHTNING = DamagingWarmupEntityEvents.getEventId();

    private static int getEventId() {
        return idCounter++;
    }

    static {
        EVENTS.put(SPAWN_FIRE, (entity, otherAttributes) -> {
            Level world = entity.m_20193_();
            if (world.m_8055_(entity.m_20183_()).m_60795_()) {
                world.m_46597_(entity.m_20183_(), Blocks.f_50083_.m_49966_());
            }
            if (entity.getParticleAmountMod() > 0.0f) {
                Map<ParticleOptions, Vec3> map = Map.of(ParticleTypes.f_175828_, entity.getParticleVec(), ParticleTypes.f_123744_, entity.getParticleVec(), (ParticleOptions)ParticleRegistry.SUN_PARTICLE.get(), entity.getParticleVec());
                ParticleHandler.particleOutburstMap(world, Math.min(30 * (int)entity.getParticleAmountMod(), 100), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), map, 0.4f);
            }
        });
        EVENTS.put(SPAWN_MOLTEN_METAL, (entity, otherAttributes) -> {
            Level world = entity.m_20193_();
            MoltenMetal crack = new MoltenMetal(world, otherAttributes.newEntityRadius);
            crack.m_36781_(otherAttributes.newEntityDamage);
            crack.m_5602_(entity.m_19749_());
            crack.m_146922_(entity.m_146908_());
            crack.m_20343_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            world.m_7967_((Entity)crack);
        });
        EVENTS.put(SPAWN_LIGHTNING, (entity, otherAttributes) -> {
            Level world = entity.m_20193_();
            if (world.m_45527_(entity.m_20183_())) {
                LightningBolt lightningEntity = new LightningBolt(EntityType.f_20465_, world);
                lightningEntity.m_20343_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                world.m_7967_((Entity)lightningEntity);
            }
        });
    }

    public record OtherAttributes(float newEntityDamage, float newEntityRadius) {
        public OtherAttributes() {
            this(0.0f, 0.0f);
        }

        public static OtherAttributes getInstanceFromNbt(CompoundTag nbt) {
            return new OtherAttributes(nbt.m_128457_("NewEntityDamage"), nbt.m_128457_("NewEntityRadius"));
        }

        public void writeCustomDataToNbt(CompoundTag nbt) {
            nbt.m_128350_("NewEntityDamage", this.newEntityDamage);
            nbt.m_128350_("NewEntityRadius", this.newEntityRadius);
        }
    }
}

