/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile.noclip;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.entity.mobs.DayStalker;
import net.soulsweaponry.entity.mobs.NightProwler;
import net.soulsweaponry.entity.mobs.WarmthEntity;
import net.soulsweaponry.entity.projectile.noclip.DamagingWarmupEntity;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;

public class AirCombustion
extends DamagingWarmupEntity {
    private boolean isEmpowered;

    public AirCombustion(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
    }

    public AirCombustion(Level world, LivingEntity livingEntity, float damage, float radius, int warmup) {
        super((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.AIR_COMBUSTION.get()), world);
        this.m_5602_((Entity)livingEntity);
        this.m_36781_(damage);
        this.setRadius(radius);
        this.setWarmup(warmup);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            ParticleHandler.particleOutburst(this.m_9236_(), 20, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), (ParticleOptions)ParticleTypes.f_123744_, new Vec3(15.0, 15.0, 15.0), 1.0f);
        }
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11936_, this.m_5720_(), 1.0f, 1.0f, true);
        this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12616_, this.m_5720_(), 1.0f, 1.0f, true);
    }

    @Override
    public void handleSoundStatus(byte status) {
        this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, this.m_5720_(), 1.0f, 1.0f, true);
    }

    @Override
    public void applyDamageEffects(boolean wasHit, LivingEntity target) {
        DamageSource damageSource;
        if (target instanceof WarmthEntity) {
            return;
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            DayStalker stalker;
            NightProwler prowler;
            ServerLevel serverWorld = (ServerLevel)level;
            level = this.m_19749_();
            if (level instanceof DayStalker && target.equals((Object)(prowler = (stalker = (DayStalker)level).getPartner(serverWorld)))) {
                return;
            }
        }
        if ((level = this.m_19749_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)level;
            damageSource = this.m_9236_().m_269111_().m_269333_(living);
        } else {
            damageSource = this.m_9236_().m_269111_().m_269299_((Entity)this, null);
        }
        DamageSource source = damageSource;
        target.m_6469_(source, (float)this.m_36789_());
        if (this.isEmpowered()) {
            target.m_20254_(4);
        }
    }

    @Override
    public void onTrigger() {
        super.onTrigger();
        ParticleEvents.airCombustionEvent(this.m_9236_(), this.m_20185_(), this.m_20227_(0.5), this.m_20189_());
    }

    public boolean isEmpowered() {
        return this.isEmpowered;
    }

    public void setEmpowered(boolean empowered) {
        this.isEmpowered = empowered;
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("isEmpowered")) {
            this.setEmpowered(nbt.m_128471_("isEmpowered"));
        }
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("isEmpowered", this.isEmpowered);
    }
}

