/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile.arrow;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.arrow.ModArrow;
import net.soulsweaponry.registry.EntityRegistry;

public class ChargedArrow
extends ModArrow {
    private boolean scaleDamageHp;

    public ChargedArrow(EntityType<? extends ChargedArrow> entityType, Level world) {
        super(entityType, world);
        this.scaleDamageHp = false;
    }

    public ChargedArrow(Level world, double x, double y, double z, boolean scaleDamageHp) {
        super((EntityType<? extends Arrow>)((EntityType)EntityRegistry.CHARGED_ARROW_ENTITY_TYPE.get()), x, y, z, world);
        this.scaleDamageHp = scaleDamageHp;
    }

    public ChargedArrow(Level world, LivingEntity owner, boolean scaleDamageHp) {
        super((EntityType<? extends Arrow>)((EntityType)EntityRegistry.CHARGED_ARROW_ENTITY_TYPE.get()), owner, world);
        this.scaleDamageHp = scaleDamageHp;
    }

    public void m_8119_() {
        if (!this.f_36703_) {
            Vec3 vec3d = this.m_20184_();
            double e = vec3d.f_82479_;
            double f = vec3d.f_82480_;
            double g = vec3d.f_82481_;
            for (int i = 0; i < 4; ++i) {
                this.m_9236_().m_7106_(this.getParticleType(), this.m_20185_() + e * (double)i / 4.0, this.m_20186_() + f * (double)i / 4.0, this.m_20189_() + g * (double)i / 4.0, -e, -f + 0.2, -g);
            }
        }
        super.m_8119_();
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("scaleDmg")) {
            this.scaleDamageHp = nbt.m_128471_("scaleDmg");
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("scaleDmg", this.scaleDamageHp);
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity;
        if (this.scaleDamageHp && (entity = entityHitResult.m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            float percentMissingHp = 100.0f - target.m_21223_() / target.m_21233_() * 100.0f;
            float increase = 1.0f + percentMissingHp / 100.0f;
            this.m_36781_(this.m_36789_() * (double)increase);
        }
        super.m_5790_(entityHitResult);
    }

    protected ParticleOptions getParticleType() {
        return ParticleTypes.f_175827_;
    }

    @Override
    public boolean canHaveArrowEffects(ItemStack arrowStack, ItemStack bowStack) {
        return ConfigConstructor.galeforce_can_apply_arrow_effects;
    }
}

