/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.LuckChosenObject;
import net.soulsweaponry.util.WeaponUtil;

public class WitheredWabbajackProjectile
extends WitherSkull {
    private static final List<LuckChosenObject<EntityType<?>>> ENTITIES = new ArrayList();
    private static final List<LuckChosenObject<CollisionEffect>> COLLISIONS = new ArrayList<LuckChosenObject<CollisionEffect>>();
    private static final List<LuckChosenObject<EntityHitEffect>> ENTITY_EFFECTS = new ArrayList<LuckChosenObject<EntityHitEffect>>();

    public WitheredWabbajackProjectile(EntityType<? extends WitheredWabbajackProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public WitheredWabbajackProjectile(Level world, LivingEntity owner, double directionX, double directionY, double directionZ) {
        this(owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), directionX, directionY, directionZ, world);
        this.m_5602_((Entity)owner);
        this.m_19915_(owner.m_146908_(), owner.m_146909_());
    }

    public WitheredWabbajackProjectile(double x, double y, double z, double directionX, double directionY, double directionZ, Level world) {
        super((EntityType)EntityRegistry.WITHERED_WABBAJACK_PROJECTILE.get(), world);
        this.m_7678_(x, y, z, this.m_146908_(), this.m_146909_());
        this.m_20090_();
        double d = Math.sqrt(directionX * directionX + directionY * directionY + directionZ * directionZ);
        if (d != 0.0) {
            this.f_36813_ = directionX / d * 0.1;
            this.f_36814_ = directionY / d * 0.1;
            this.f_36815_ = directionZ / d * 0.1;
        }
    }

    protected float m_6884_() {
        return 1.0f;
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        if (!this.m_9236_().f_46443_) {
            Entity entity = entityHitResult.m_82443_();
            Entity owner = this.m_19749_();
            if (entity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                if (owner instanceof LivingEntity) {
                    LivingEntity user = (LivingEntity)owner;
                    int power = this.getBound(75, 5, user) + WeaponUtil.getLuckFactor(user) * 5;
                    int amplifier = this.getBound(3, 1, user) + WeaponUtil.getLuckFactor(user) / 2;
                    int duration = this.getBound(300, 50, user) + WeaponUtil.getLuckFactor(user) * 50;
                    switch (this.getRandomEntityHitEffect(user).ordinal()) {
                        case 0: {
                            target.m_7292_(new MobEffectInstance(this.getRandomEffect(true), duration, amplifier));
                            break;
                        }
                        case 1: {
                            user.m_7292_(new MobEffectInstance(this.getRandomEffect(false), duration, amplifier));
                            break;
                        }
                        case 2: {
                            boolean luck = this.getBound(20, 1, user) + WeaponUtil.getLuckFactor(user) > 10;
                            LivingEntity living = luck ? target : user;
                            living.m_6168_().iterator().forEachRemaining(itemStack -> {
                                boolean bl = this.f_19796_.m_188499_();
                                if (bl) {
                                    ItemStack separate = itemStack.m_41777_();
                                    living.m_19983_(separate);
                                    itemStack.m_41774_(1);
                                    this.m_9236_().m_5594_(null, living.m_20183_(), SoundEvents.f_11681_, SoundSource.PLAYERS, 1.0f, 1.0f);
                                }
                            });
                            break;
                        }
                        case 4: {
                            target.m_5997_(0.0, (double)((float)power * 0.05f), 0.0);
                            break;
                        }
                        case 5: {
                            target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.CHUNGUS_TONIC_EFFECT.get(), 200, 0));
                            break;
                        }
                        default: {
                            if (power > 50) {
                                this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.CRIT_HIT_EVENT.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
                            }
                            target.m_6469_(this.m_9236_().m_269111_().m_269425_(), (float)power);
                        }
                    }
                }
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 100) {
            this.resetListLuckFactors();
            this.m_146870_();
        }
    }

    private void resetListLuckFactors() {
        for (LuckChosenObject<EntityType<?>> luckChosenObject : ENTITIES) {
            luckChosenObject.setLuckFactor(10);
        }
        for (LuckChosenObject<Object> luckChosenObject : COLLISIONS) {
            luckChosenObject.setLuckFactor(10);
        }
    }

    protected void m_6532_(HitResult hitResult) {
        HitResult.Type type = hitResult.m_6662_();
        if (type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)hitResult);
            this.m_9236_().m_214171_(GameEvent.f_157777_, hitResult.m_82450_(), GameEvent.Context.m_223719_((Entity)this, null));
        } else if (type == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            this.m_8060_(blockHitResult);
            BlockPos blockPos = blockHitResult.m_82425_();
            this.m_9236_().m_220407_(GameEvent.f_157777_, blockPos, GameEvent.Context.m_223719_((Entity)this, (BlockState)this.m_9236_().m_8055_(blockPos)));
        }
        if (this.m_19749_() != null && this.m_19749_() instanceof LivingEntity) {
            this.randomCollisionEffect((LivingEntity)this.m_19749_());
        }
        this.resetListLuckFactors();
        this.m_146870_();
    }

    private void randomCollisionEffect(LivingEntity user) {
        boolean unluckyAf;
        int power = this.getBound(10, 1, user) + WeaponUtil.getLuckFactor(user);
        boolean bl = unluckyAf = this.getBound(100, 10, user) == 1;
        if (unluckyAf) {
            boolean isWarden = this.f_19796_.m_188499_();
            for (int i = 0; i < 3; ++i) {
                if (isWarden && !this.m_9236_().f_46443_) {
                    Warden warden = new Warden(EntityType.f_217015_, this.m_9236_());
                    warden.m_6518_((ServerLevelAccessor)this.m_9236_(), this.m_9236_().m_6436_(user.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    warden.m_20343_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    warden.m_219387_((Entity)user, 80, true);
                    this.m_9236_().m_7967_((Entity)warden);
                    continue;
                }
                WitherBoss boss = new WitherBoss(EntityType.f_20496_, this.m_9236_());
                boss.m_20343_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                this.m_9236_().m_7967_((Entity)boss);
            }
            return;
        }
        switch (this.getCollisionEffectType(user).ordinal()) {
            case 3: {
                for (int i = 0; i < power * 2; ++i) {
                    Bat bat = new Bat(EntityType.f_20549_, this.m_9236_());
                    bat.m_20343_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    this.m_9236_().m_7967_((Entity)bat);
                }
                break;
            }
            case 5: {
                this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundEvents.f_11689_.m_203334_(), SoundSource.AMBIENT, 1.0f, 1.0f);
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_215781_, SoundSource.HOSTILE, 1.0f, 1.0f);
                user.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 60, 0));
                break;
            }
            case 0: {
                for (int i = 0; i < power; ++i) {
                    LightningBolt entity = new LightningBolt(EntityType.f_20465_, this.m_9236_());
                    entity.m_20343_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    this.m_9236_().m_7967_((Entity)entity);
                }
                break;
            }
            case 4: {
                if (this.m_9236_().f_46443_) break;
                SimpleParticleType particle = this.getRandomParticle();
                int amount = 1000;
                if (particle == ParticleTypes.f_123807_) {
                    amount = 1;
                }
                ParticleHandler.particleSphereList(this.m_9236_(), amount, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, new ParticleOptions[]{particle});
                break;
            }
            case 1: {
                this.summonRandomEntity(user, power);
                break;
            }
            case 2: {
                this.summonSpecificEntity(user, power);
                break;
            }
            case 7: {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123807_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                this.m_9236_().m_5594_(null, user.m_20183_(), SoundEvents.f_11880_, SoundSource.HOSTILE, 1.0f, 1.0f);
                user.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 5));
                break;
            }
            default: {
                boolean bl2 = this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_);
                this.m_9236_().m_255391_(this.m_19749_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)power, bl2, bl2 ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE);
            }
        }
    }

    private SimpleParticleType getRandomParticle() {
        Random number = new Random();
        ArrayList arr = new ArrayList();
        BuiltInRegistries.f_257034_.m_123024_().forEach(p -> {
            if (p instanceof SimpleParticleType) {
                SimpleParticleType d = (SimpleParticleType)p;
                arr.add(d);
            }
        });
        int rng = number.nextInt(arr.size());
        return (SimpleParticleType)arr.get(rng);
    }

    private void summonSpecificEntity(LivingEntity user, int power) {
        if (!this.m_9236_().f_46443_) {
            EntityType<?> type = this.getEntityType(user);
            for (int i = 0; i < power; ++i) {
                type.m_262496_((ServerLevel)this.m_9236_(), this.m_20183_(), MobSpawnType.EVENT);
            }
        }
    }

    private void summonRandomEntity(LivingEntity user, int power) {
        if (!this.m_9236_().f_46443_) {
            for (int i = 0; i < power; ++i) {
                EntityType<?> type = this.getEntityType(user);
                type.m_262496_((ServerLevel)this.m_9236_(), this.m_20183_(), MobSpawnType.EVENT);
            }
        }
    }

    private int getBound(int bound, int luckModifier, LivingEntity user) {
        int b = bound + WeaponUtil.getLuckFactor(user) * luckModifier;
        return b > 0 ? this.f_19796_.m_188503_(b) : 1;
    }

    private CollisionEffect getCollisionEffectType(LivingEntity user) {
        return (CollisionEffect)((Object)WeaponUtil.getRandomlyChosenObject(user, COLLISIONS, false));
    }

    private EntityType<?> getEntityType(LivingEntity user) {
        return (EntityType)WeaponUtil.getRandomlyChosenObject(user, ENTITIES, false);
    }

    private MobEffect getRandomEffect(boolean flipLuckTypes) {
        if (this.m_19749_() instanceof LivingEntity) {
            return (MobEffect)WeaponUtil.getRandomlyChosenObject((LivingEntity)this.m_19749_(), this.getEffectList(), flipLuckTypes);
        }
        return MobEffects.f_19619_;
    }

    private EntityHitEffect getRandomEntityHitEffect(LivingEntity user) {
        return (EntityHitEffect)((Object)WeaponUtil.getRandomlyChosenObject(user, ENTITY_EFFECTS, false));
    }

    private List<LuckChosenObject<MobEffect>> getEffectList() {
        ArrayList<LuckChosenObject<MobEffect>> list = new ArrayList<LuckChosenObject<MobEffect>>();
        for (MobEffect effect : ForgeRegistries.MOB_EFFECTS) {
            if (effect.m_19483_().equals((Object)MobEffectCategory.HARMFUL)) {
                list.add(new LuckChosenObject<MobEffect>(effect, WeaponUtil.LuckType.BAD));
                continue;
            }
            if (effect.m_19483_().equals((Object)MobEffectCategory.BENEFICIAL)) {
                list.add(new LuckChosenObject<MobEffect>(effect, WeaponUtil.LuckType.GOOD));
                continue;
            }
            list.add(new LuckChosenObject<MobEffect>(effect, WeaponUtil.LuckType.NEUTRAL));
        }
        return list;
    }

    static {
        ENTITIES.add(new LuckChosenObject<EntityType>(EntityType.f_20558_, WeaponUtil.LuckType.BAD));
        ENTITIES.add(new LuckChosenObject<EntityType>(EntityType.f_20501_, WeaponUtil.LuckType.BAD));
        ENTITIES.add(new LuckChosenObject<EntityType>(EntityType.f_20567_, WeaponUtil.LuckType.BAD));
        ENTITIES.add(new LuckChosenObject<EntityType>(EntityType.f_20550_, WeaponUtil.LuckType.BAD));
        ENTITIES.add(new LuckChosenObject<EntityType>(EntityType.f_20516_, WeaponUtil.LuckType.BAD));
        ENTITIES.add(new LuckChosenObject<EntityType>(EntityType.f_20491_, WeaponUtil.LuckType.BAD));
        ENTITIES.add(new LuckChosenObject<EntityType>(EntityType.f_20524_, WeaponUtil.LuckType.BAD));
        ENTITIES.add(new LuckChosenObject<EntityType>(EntityType.f_20562_, WeaponUtil.LuckType.BAD));
        ENTITIES.add(new LuckChosenObject<EntityType>(EntityType.f_20455_, WeaponUtil.LuckType.BAD));
        ENTITIES.add(new LuckChosenObject<EntityType>(EntityType.f_20519_, WeaponUtil.LuckType.NEUTRAL));
        ENTITIES.add(new LuckChosenObject<EntityType>(EntityType.f_20557_, WeaponUtil.LuckType.NEUTRAL));
        ENTITIES.add(new LuckChosenObject<EntityType>(EntityType.f_20556_, WeaponUtil.LuckType.NEUTRAL));
        ENTITIES.add(new LuckChosenObject<EntityType>(EntityType.f_20489_, WeaponUtil.LuckType.NEUTRAL));
        ENTITIES.add(new LuckChosenObject<EntityType>(EntityType.f_20494_, WeaponUtil.LuckType.NEUTRAL));
        ENTITIES.add(new LuckChosenObject<EntityType>(EntityType.f_20555_, WeaponUtil.LuckType.NEUTRAL));
        ENTITIES.add(new LuckChosenObject<EntityType>(EntityType.f_20520_, WeaponUtil.LuckType.NEUTRAL));
        ENTITIES.add(new LuckChosenObject<EntityType>(EntityType.f_20570_, WeaponUtil.LuckType.GOOD));
        COLLISIONS.add(new LuckChosenObject<CollisionEffect>(CollisionEffect.RANDOM_ENTITY, WeaponUtil.LuckType.BAD));
        COLLISIONS.add(new LuckChosenObject<CollisionEffect>(CollisionEffect.SPECIFIC_ENTITY, WeaponUtil.LuckType.BAD));
        COLLISIONS.add(new LuckChosenObject<CollisionEffect>(CollisionEffect.BATS, WeaponUtil.LuckType.BAD));
        COLLISIONS.add(new LuckChosenObject<CollisionEffect>(CollisionEffect.PARTICLES, WeaponUtil.LuckType.BAD));
        COLLISIONS.add(new LuckChosenObject<CollisionEffect>(CollisionEffect.DARKNESS, WeaponUtil.LuckType.BAD));
        COLLISIONS.add(new LuckChosenObject<CollisionEffect>(CollisionEffect.CURSE, WeaponUtil.LuckType.BAD));
        COLLISIONS.add(new LuckChosenObject<CollisionEffect>(CollisionEffect.LIGHTNING, WeaponUtil.LuckType.GOOD));
        COLLISIONS.add(new LuckChosenObject<CollisionEffect>(CollisionEffect.EXPLOSION, WeaponUtil.LuckType.GOOD));
        ENTITY_EFFECTS.add(new LuckChosenObject<EntityHitEffect>(EntityHitEffect.RANDOM_EFFECT_TARGET, WeaponUtil.LuckType.NEUTRAL, 40));
        ENTITY_EFFECTS.add(new LuckChosenObject<EntityHitEffect>(EntityHitEffect.RANDOM_EFFECT_USER, WeaponUtil.LuckType.NEUTRAL, 30));
        ENTITY_EFFECTS.add(new LuckChosenObject<EntityHitEffect>(EntityHitEffect.DROP_ARMOR, WeaponUtil.LuckType.NEUTRAL, 5));
        ENTITY_EFFECTS.add(new LuckChosenObject<EntityHitEffect>(EntityHitEffect.RANDOM_DAMAGE, WeaponUtil.LuckType.NEUTRAL, 40));
        ENTITY_EFFECTS.add(new LuckChosenObject<EntityHitEffect>(EntityHitEffect.LAUNCH, WeaponUtil.LuckType.NEUTRAL, 10));
        ENTITY_EFFECTS.add(new LuckChosenObject<EntityHitEffect>(EntityHitEffect.CHUNGUS_TONIC, WeaponUtil.LuckType.NEUTRAL, 10));
    }

    static enum EntityHitEffect {
        RANDOM_EFFECT_TARGET,
        RANDOM_EFFECT_USER,
        DROP_ARMOR,
        RANDOM_DAMAGE,
        LAUNCH,
        CHUNGUS_TONIC;

    }

    static enum CollisionEffect {
        LIGHTNING,
        RANDOM_ENTITY,
        SPECIFIC_ENTITY,
        BATS,
        PARTICLES,
        DARKNESS,
        EXPLOSION,
        CURSE;

    }
}

